/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.energy.forgeenergy;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.common.integration.energy.EnergyCompatUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraftforge.energy.IEnergyStorage;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ForgeStrictEnergyHandler
implements IStrictEnergyHandler {
    private final IEnergyStorage storage;

    public ForgeStrictEnergyHandler(IEnergyStorage storage) {
        this.storage = storage;
    }

    @Override
    public int getEnergyContainerCount() {
        return 1;
    }

    @Override
    public FloatingLong getEnergy(int container) {
        return container == 0 ? EnergyCompatUtils.EnergyType.FORGE.convertFrom(this.storage.getEnergyStored()) : FloatingLong.ZERO;
    }

    @Override
    public void setEnergy(int container, FloatingLong energy) {
    }

    @Override
    public FloatingLong getMaxEnergy(int container) {
        return container == 0 ? EnergyCompatUtils.EnergyType.FORGE.convertFrom(this.storage.getMaxEnergyStored()) : FloatingLong.ZERO;
    }

    @Override
    public FloatingLong getNeededEnergy(int container) {
        return container == 0 ? EnergyCompatUtils.EnergyType.FORGE.convertFrom(Math.max(0, this.storage.getMaxEnergyStored() - this.storage.getEnergyStored())) : FloatingLong.ZERO;
    }

    @Override
    public FloatingLong insertEnergy(int container, FloatingLong amount, @Nonnull Action action) {
        int inserted;
        if (container == 0 && this.storage.canReceive() && (inserted = this.storage.receiveEnergy(EnergyCompatUtils.EnergyType.FORGE.convertToAsInt(amount), action.simulate())) > 0) {
            return amount.subtract(EnergyCompatUtils.EnergyType.FORGE.convertFrom(inserted));
        }
        return amount;
    }

    @Override
    public FloatingLong extractEnergy(int container, FloatingLong amount, @Nonnull Action action) {
        if (container == 0 && this.storage.canExtract()) {
            return EnergyCompatUtils.EnergyType.FORGE.convertFrom(this.storage.extractEnergy(EnergyCompatUtils.EnergyType.FORGE.convertToAsInt(amount), action.simulate()));
        }
        return FloatingLong.ZERO;
    }
}

