/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NonNull;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.IFluidHandlerSlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.inventory.slot.chemical.InfusionInventorySlot;
import mekanism.common.inventory.slot.chemical.MergedChemicalInventorySlot;
import mekanism.common.inventory.slot.chemical.PigmentInventorySlot;
import mekanism.common.inventory.slot.chemical.SlurryInventorySlot;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidUtil;

public class HybridInventorySlot
extends MergedChemicalInventorySlot<MergedTank>
implements IFluidHandlerSlot {
    private boolean isDraining;
    private boolean isFilling;

    private static boolean hasCapability(@Nonnull ItemStack stack) {
        return FluidUtil.getFluidHandler((ItemStack)stack).isPresent() || stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).isPresent() || stack.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY).isPresent() || stack.getCapability(Capabilities.PIGMENT_HANDLER_CAPABILITY).isPresent() || stack.getCapability(Capabilities.SLURRY_HANDLER_CAPABILITY).isPresent();
    }

    public static HybridInventorySlot inputOrDrain(MergedTank mergedTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(mergedTank, "Merged tank cannot be null");
        Predicate<@NonNull ItemStack> fluidInsertPredicate = FluidInventorySlot.getInputPredicate(mergedTank.getFluidTank());
        Predicate<@NonNull ItemStack> gasInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(mergedTank.getGasTank(), GasInventorySlot::getCapability);
        Predicate<@NonNull ItemStack> infusionInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(mergedTank.getInfusionTank(), InfusionInventorySlot::getCapability);
        Predicate<@NonNull ItemStack> pigmentInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(mergedTank.getPigmentTank(), PigmentInventorySlot::getCapability);
        Predicate<@NonNull ItemStack> slurryInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(mergedTank.getSlurryTank(), SlurryInventorySlot::getCapability);
        BiPredicate<@NonNull ItemStack, @NonNull AutomationType> insertPredicate = (stack, automationType) -> {
            MergedTank.CurrentType currentType = mergedTank.getCurrentType();
            if (currentType == MergedTank.CurrentType.FLUID) {
                return fluidInsertPredicate.test((ItemStack)stack);
            }
            if (currentType == MergedTank.CurrentType.GAS) {
                return gasInsertPredicate.test((ItemStack)stack);
            }
            if (currentType == MergedTank.CurrentType.INFUSION) {
                return infusionInsertPredicate.test((ItemStack)stack);
            }
            if (currentType == MergedTank.CurrentType.PIGMENT) {
                return pigmentInsertPredicate.test((ItemStack)stack);
            }
            if (currentType == MergedTank.CurrentType.SLURRY) {
                return slurryInsertPredicate.test((ItemStack)stack);
            }
            return fluidInsertPredicate.test((ItemStack)stack) || gasInsertPredicate.test((ItemStack)stack) || infusionInsertPredicate.test((ItemStack)stack) || pigmentInsertPredicate.test((ItemStack)stack) || slurryInsertPredicate.test((ItemStack)stack);
        };
        return new HybridInventorySlot(mergedTank, (stack, automationType) -> automationType == AutomationType.MANUAL || !insertPredicate.test((ItemStack)stack, (AutomationType)((Object)automationType)), insertPredicate, HybridInventorySlot::hasCapability, listener, x, y);
    }

    public static HybridInventorySlot outputOrFill(MergedTank mergedTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(mergedTank, "Merged tank cannot be null");
        Predicate<@NonNull ItemStack> gasExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(mergedTank.getGasTank(), GasInventorySlot::getCapability);
        Predicate<@NonNull ItemStack> infusionExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(mergedTank.getInfusionTank(), InfusionInventorySlot::getCapability);
        Predicate<@NonNull ItemStack> pigmentExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(mergedTank.getPigmentTank(), PigmentInventorySlot::getCapability);
        Predicate<@NonNull ItemStack> slurryExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(mergedTank.getSlurryTank(), SlurryInventorySlot::getCapability);
        Predicate<@NonNull ItemStack> gasInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(mergedTank.getGasTank(), GasInventorySlot.getCapability(stack));
        Predicate<@NonNull ItemStack> infusionInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(mergedTank.getInfusionTank(), InfusionInventorySlot.getCapability(stack));
        Predicate<@NonNull ItemStack> pigmentInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(mergedTank.getPigmentTank(), PigmentInventorySlot.getCapability(stack));
        Predicate<@NonNull ItemStack> slurryInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(mergedTank.getSlurryTank(), SlurryInventorySlot.getCapability(stack));
        return new HybridInventorySlot(mergedTank, (stack, automationType) -> {
            if (automationType == AutomationType.MANUAL) {
                return true;
            }
            MergedTank.CurrentType currentType = mergedTank.getCurrentType();
            if (currentType == MergedTank.CurrentType.FLUID) {
                return true;
            }
            if (currentType == MergedTank.CurrentType.GAS) {
                return gasExtractPredicate.test((ItemStack)stack);
            }
            if (currentType == MergedTank.CurrentType.INFUSION) {
                return infusionExtractPredicate.test((ItemStack)stack);
            }
            if (currentType == MergedTank.CurrentType.PIGMENT) {
                return pigmentExtractPredicate.test((ItemStack)stack);
            }
            if (currentType == MergedTank.CurrentType.SLURRY) {
                return slurryExtractPredicate.test((ItemStack)stack);
            }
            return gasExtractPredicate.test((ItemStack)stack) && infusionExtractPredicate.test((ItemStack)stack) && pigmentExtractPredicate.test((ItemStack)stack) && slurryExtractPredicate.test((ItemStack)stack);
        }, (stack, automationType) -> {
            MergedTank.CurrentType currentType = mergedTank.getCurrentType();
            if (currentType == MergedTank.CurrentType.FLUID) {
                return automationType == AutomationType.INTERNAL;
            }
            if (currentType == MergedTank.CurrentType.GAS) {
                return gasInsertPredicate.test((ItemStack)stack);
            }
            if (currentType == MergedTank.CurrentType.INFUSION) {
                return infusionInsertPredicate.test((ItemStack)stack);
            }
            if (currentType == MergedTank.CurrentType.PIGMENT) {
                return pigmentInsertPredicate.test((ItemStack)stack);
            }
            if (currentType == MergedTank.CurrentType.SLURRY) {
                return slurryInsertPredicate.test((ItemStack)stack);
            }
            if (automationType == AutomationType.INTERNAL && FluidUtil.getFluidHandler((ItemStack)stack).isPresent()) {
                return true;
            }
            return gasInsertPredicate.test((ItemStack)stack) || infusionInsertPredicate.test((ItemStack)stack) || pigmentInsertPredicate.test((ItemStack)stack) || slurryInsertPredicate.test((ItemStack)stack);
        }, HybridInventorySlot::hasCapability, listener, x, y);
    }

    private HybridInventorySlot(MergedTank mergedTank, BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canExtract, BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canInsert, Predicate<@NonNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        super(mergedTank, canExtract, canInsert, validator, listener, x, y);
    }

    @Override
    public IExtendedFluidTank getFluidTank() {
        return ((MergedTank)this.mergedTank).getFluidTank();
    }

    @Override
    public boolean isDraining() {
        return this.isDraining;
    }

    @Override
    public boolean isFilling() {
        return this.isFilling;
    }

    @Override
    public void setDraining(boolean draining) {
        this.isDraining = draining;
    }

    @Override
    public void setFilling(boolean filling) {
        this.isFilling = filling;
    }

    @Override
    @Nonnull
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        if (this.isDraining) {
            nbt.m_128379_("draining", true);
        }
        if (this.isFilling) {
            nbt.m_128379_("filling", true);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(@Nonnull CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.isDraining = nbt.m_128471_("draining");
        this.isFilling = nbt.m_128471_("filling");
    }
}

