/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.fluid.IExtendedFluidHandler;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.merged.GaugeDropperContentsHandler;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class ItemGaugeDropper
extends Item {
    public ItemGaugeDropper(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.UNCOMMON));
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return true;
    }

    public int m_142158_(@Nonnull ItemStack stack) {
        return StorageUtils.getBarWidth(stack);
    }

    public int m_142159_(@Nonnull ItemStack stack) {
        return FluidUtils.getRGBDurabilityForDisplay(stack).orElseGet(() -> ChemicalUtil.getRGBDurabilityForDisplay(stack));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (!world.f_46443_) {
                IFluidHandlerItem fluidHandler;
                Optional fluidCapability = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
                if (fluidCapability.isPresent() && (fluidHandler = (IFluidHandlerItem)fluidCapability.get()) instanceof IExtendedFluidHandler) {
                    IExtendedFluidHandler fluidHandlerItem = (IExtendedFluidHandler)fluidHandler;
                    for (int tank = 0; tank < fluidHandlerItem.getTanks(); ++tank) {
                        fluidHandlerItem.setFluidInTank(tank, FluidStack.EMPTY);
                    }
                }
                ItemGaugeDropper.clearChemicalTanks(stack, GasStack.EMPTY);
                ItemGaugeDropper.clearChemicalTanks(stack, InfusionStack.EMPTY);
                ItemGaugeDropper.clearChemicalTanks(stack, PigmentStack.EMPTY);
                ItemGaugeDropper.clearChemicalTanks(stack, SlurryStack.EMPTY);
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.f_46443_);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void clearChemicalTanks(ItemStack stack, STACK empty) {
        Optional cap = stack.getCapability(ChemicalUtil.getCapabilityForChemical(empty)).resolve();
        if (cap.isPresent()) {
            IChemicalHandler handler = (IChemicalHandler)cap.get();
            for (int tank = 0; tank < handler.getTanks(); ++tank) {
                handler.setChemicalInTank(tank, empty);
            }
        }
    }

    public void m_7373_(@Nonnull ItemStack stack, Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        StorageUtils.addStoredSubstance(stack, tooltip, false);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new ItemCapabilityWrapper(stack, GaugeDropperContentsHandler.create());
    }
}

