/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.ItemEnergized;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IFrequencyItem;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemPortableTeleporter
extends ItemEnergized
implements IFrequencyItem {
    public ItemPortableTeleporter(Item.Properties properties) {
        super(MekanismConfig.gear.portableTeleporterChargeRate, MekanismConfig.gear.portableTeleporterMaxEnergy, properties.m_41497_(Rarity.RARE));
    }

    @Override
    public void m_7373_(@Nonnull ItemStack stack, Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        tooltip.add(OwnerDisplay.of(MekanismUtils.tryGetClientPlayer(), this.getOwnerUUID(stack)).getTextComponent());
        MekanismUtils.addFrequencyItemTooltip(stack, tooltip);
        super.m_7373_(stack, world, tooltip, flag);
    }

    @Override
    public FrequencyType<?> getFrequencyType() {
        return FrequencyType.TELEPORTER;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.getOwnerUUID(stack) == null) {
            if (!world.f_46443_) {
                SecurityUtils.claimItem(player, stack);
            }
        } else if (SecurityUtils.canAccess(player, stack)) {
            if (!world.f_46443_) {
                MekanismContainerTypes.PORTABLE_TELEPORTER.tryOpenGui((ServerPlayer)player, hand, stack);
            }
        } else {
            if (!world.f_46443_) {
                SecurityUtils.displayNoAccess(player);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.f_46443_);
    }
}

