/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block.machine;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.item.RateLimitEnergyHandler;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.lib.security.ISecurityItem;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemBlockLaser
extends ItemBlockTooltip<BlockTile.BlockTileModel<?, ?>>
implements ISecurityItem {
    public ItemBlockLaser(BlockTile.BlockTileModel<?, ?> block) {
        super(block, true, ItemDeferredRegister.getMekBaseProperties().m_41487_(1));
    }

    @Override
    protected void addDetails(@Nonnull ItemStack stack, Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        SecurityUtils.addSecurityTooltip(stack, tooltip);
        StorageUtils.addStoredEnergy(stack, tooltip, true);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        AttributeEnergy attributeEnergy = Attribute.get(this.m_40614_(), AttributeEnergy.class);
        ItemCapabilityWrapper.ItemCapability[] itemCapabilityArray = new ItemCapabilityWrapper.ItemCapability[1];
        itemCapabilityArray[0] = RateLimitEnergyHandler.create(attributeEnergy::getStorage, BasicEnergyContainer.manualOnly, BasicEnergyContainer.alwaysTrue);
        return new ItemCapabilityWrapper(stack, itemCapabilityArray);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }
}

