/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.block.BlockBounding;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.mekatool.ModuleAttackAmplificationUnit;
import mekanism.common.content.gear.mekatool.ModuleExcavationEscalationUnit;
import mekanism.common.content.gear.mekatool.ModuleTeleportationUnit;
import mekanism.common.content.gear.mekatool.ModuleVeinMiningUnit;
import mekanism.common.content.gear.shared.ModuleEnergyUnit;
import mekanism.common.item.ItemEnergized;
import mekanism.common.item.gear.ItemAtomicDisassembler;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.network.to_client.PacketPortalFX;
import mekanism.common.registries.MekanismModules;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.fluids.IFluidBlock;

public class ItemMekaTool
extends ItemEnergized
implements IModuleContainerItem,
IModeItem {
    private final Multimap<Attribute, AttributeModifier> attributes;

    public ItemMekaTool(Item.Properties properties) {
        super(MekanismConfig.gear.mekaToolBaseChargeRate, MekanismConfig.gear.mekaToolBaseEnergyCapacity, properties.m_41497_(Rarity.EPIC).setNoRepair());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.4, AttributeModifier.Operation.ADDITION));
        this.attributes = builder.build();
    }

    public boolean m_8096_(@Nonnull BlockState state) {
        return true;
    }

    @Override
    public void m_7373_(@Nonnull ItemStack stack, Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed(MekanismKeyHandler.detailsKey)) {
            this.addModuleDetails(stack, tooltip);
        } else {
            StorageUtils.addStoredEnergy(stack, tooltip, true);
            tooltip.add((Component)MekanismLang.HOLD_FOR_MODULES.translateColored(EnumColor.GRAY, EnumColor.INDIGO, MekanismKeyHandler.detailsKey.m_90863_()));
        }
    }

    public boolean canPerformAction(ItemStack stack, ToolAction action) {
        if (ItemAtomicDisassembler.ALWAYS_SUPPORTED_ACTIONS.contains(action)) {
            return true;
        }
        return this.getModules(stack).stream().anyMatch(module -> module.isEnabled() && this.canPerformAction((IModule)module, action));
    }

    private <MODULE extends ICustomModule<MODULE>> boolean canPerformAction(IModule<MODULE> module, ToolAction action) {
        return module.getCustomInstance().canPerformAction(module, action);
    }

    public boolean m_5812_(@Nonnull ItemStack stack) {
        return !stack.m_41619_() && super.m_5812_(stack) && IModuleContainerItem.hasOtherEnchants(stack);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        for (Module module : this.getModules(context.m_43722_())) {
            InteractionResult result;
            if (!module.isEnabled() || (result = this.onModuleUse(module, context)) == InteractionResult.PASS) continue;
            return result;
        }
        return super.m_6225_(context);
    }

    private <MODULE extends ICustomModule<MODULE>> InteractionResult onModuleUse(IModule<MODULE> module, UseOnContext context) {
        return module.getCustomInstance().onItemUse(module, context);
    }

    @Nonnull
    public InteractionResult m_6880_(@Nonnull ItemStack stack, @Nonnull Player player, @Nonnull LivingEntity entity, @Nonnull InteractionHand hand) {
        for (Module module : this.getModules(stack)) {
            InteractionResult result;
            if (!module.isEnabled() || (result = this.onModuleInteract(module, player, entity, hand)) == InteractionResult.PASS) continue;
            return result;
        }
        return super.m_6880_(stack, player, entity, hand);
    }

    private <MODULE extends ICustomModule<MODULE>> InteractionResult onModuleInteract(IModule<MODULE> module, @Nonnull Player player, @Nonnull LivingEntity entity, @Nonnull InteractionHand hand) {
        return module.getCustomInstance().onInteract(module, player, entity, hand);
    }

    public float m_8102_(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer == null) {
            return 0.0f;
        }
        FloatingLong energyRequired = this.getDestroyEnergy(stack, state.f_60599_, this.isModuleEnabled(stack, MekanismModules.SILK_TOUCH_UNIT));
        FloatingLong energyAvailable = energyContainer.extract(energyRequired, Action.SIMULATE, AutomationType.MANUAL);
        if (energyAvailable.smallerThan(energyRequired)) {
            return MekanismConfig.gear.mekaToolBaseEfficiency.get() * energyAvailable.divide(energyRequired).floatValue();
        }
        IModule module = this.getModule(stack, MekanismModules.EXCAVATION_ESCALATION_UNIT);
        return module == null || !module.isEnabled() ? MekanismConfig.gear.mekaToolBaseEfficiency.get() : ((ModuleExcavationEscalationUnit)module.getCustomInstance()).getEfficiency();
    }

    public boolean m_6813_(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity entityliving) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer != null) {
            FloatingLong energyRequired = this.getDestroyEnergy(stack, state.m_60800_((BlockGetter)world, pos), this.isModuleEnabled(stack, MekanismModules.SILK_TOUCH_UNIT));
            energyContainer.extract(energyRequired, Action.EXECUTE, AutomationType.MANUAL);
        }
        return true;
    }

    public boolean onLeftClickEntity(@Nonnull ItemStack stack, @Nonnull Player player, @Nonnull Entity target) {
        if (target.m_6095_().m_204039_(MekanismTags.Entities.HURTABLE_VEHICLES) && target.m_6097_() && !target.m_7313_((Entity)player)) {
            int maxDamage = MekanismConfig.gear.mekaToolBaseDamage.get();
            IModule attackAmplificationUnit = this.getModule(stack, MekanismModules.ATTACK_AMPLIFICATION_UNIT);
            if (attackAmplificationUnit != null && attackAmplificationUnit.isEnabled()) {
                maxDamage += ((ModuleAttackAmplificationUnit)attackAmplificationUnit.getCustomInstance()).getDamage();
            }
            target.m_6469_(DamageSource.m_19344_((Player)player), (float)maxDamage);
        }
        return super.onLeftClickEntity(stack, player, target);
    }

    public boolean m_7579_(@Nonnull ItemStack stack, @Nonnull LivingEntity target, @Nonnull LivingEntity attacker) {
        int minDamage;
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        FloatingLong energy = energyContainer == null ? FloatingLong.ZERO : energyContainer.getEnergy();
        FloatingLong energyCost = FloatingLong.ZERO;
        int maxDamage = minDamage = MekanismConfig.gear.mekaToolBaseDamage.get();
        IModule attackAmplificationUnit = this.getModule(stack, MekanismModules.ATTACK_AMPLIFICATION_UNIT);
        if (attackAmplificationUnit != null && attackAmplificationUnit.isEnabled()) {
            if ((maxDamage += ((ModuleAttackAmplificationUnit)attackAmplificationUnit.getCustomInstance()).getDamage()) > minDamage) {
                energyCost = ((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageWeapon.get()).multiply((float)(maxDamage - minDamage) / 4.0f);
            }
            minDamage = Math.min(minDamage, maxDamage);
        }
        int damageDifference = maxDamage - minDamage;
        double percent = 1.0;
        if (energy.smallerThan(energyCost)) {
            percent = energy.divideToLevel(energyCost);
        }
        float damage = (float)((double)minDamage + (double)damageDifference * percent);
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            target.m_6469_(DamageSource.m_19344_((Player)player), damage);
        } else {
            target.m_6469_(DamageSource.m_19370_((LivingEntity)attacker), damage);
        }
        if (energyContainer != null && !energy.isZero()) {
            energyContainer.extract(energyCost, Action.EXECUTE, AutomationType.MANUAL);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        if (player.f_19853_.f_46443_ || player.m_7500_()) {
            return super.onBlockStartBreak(stack, pos, player);
        }
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer != null) {
            boolean isOre;
            IModule veinMiningUnit;
            Level world = player.f_19853_;
            BlockState state = world.m_8055_(pos);
            boolean silk = this.isModuleEnabled(stack, MekanismModules.SILK_TOUCH_UNIT);
            FloatingLong energyRequired = this.getDestroyEnergy(stack, state.m_60800_((BlockGetter)world, pos), silk);
            if (energyContainer.extract(energyRequired, Action.SIMULATE, AutomationType.MANUAL).greaterOrEqual(energyRequired) && (veinMiningUnit = this.getModule(stack, MekanismModules.VEIN_MINING_UNIT)) != null && veinMiningUnit.isEnabled() && !(state.m_60734_() instanceof BlockBounding) && ((isOre = state.m_204336_(MekanismTags.Blocks.ATOMIC_DISASSEMBLER_ORE)) || ((ModuleVeinMiningUnit)veinMiningUnit.getCustomInstance()).isExtended())) {
                FloatingLong baseDestroyEnergy = this.getDestroyEnergy(silk);
                Set<BlockPos> found = ModuleVeinMiningUnit.findPositions(state, pos, world, isOre ? -1 : ((ModuleVeinMiningUnit)veinMiningUnit.getCustomInstance()).getExcavationRange());
                MekanismUtils.veinMineArea(energyContainer, world, pos, (ServerPlayer)player, stack, this, found, hardness -> this.getDestroyEnergy(baseDestroyEnergy, hardness.floatValue()), distance -> 0.5 * Math.pow(distance, isOre ? 1.5 : 2.0), state);
            }
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    private FloatingLong getDestroyEnergy(boolean silk) {
        return silk ? (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageSilk.get() : (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsage.get();
    }

    public FloatingLong getDestroyEnergy(ItemStack itemStack, float hardness, boolean silk) {
        return this.getDestroyEnergy(this.getDestroyEnergy(itemStack, silk), hardness);
    }

    private FloatingLong getDestroyEnergy(FloatingLong baseDestroyEnergy, float hardness) {
        return hardness == 0.0f ? baseDestroyEnergy.divide(2L) : baseDestroyEnergy;
    }

    private FloatingLong getDestroyEnergy(ItemStack itemStack, boolean silk) {
        FloatingLong destroyEnergy = this.getDestroyEnergy(silk);
        IModule module = this.getModule(itemStack, MekanismModules.EXCAVATION_ESCALATION_UNIT);
        float efficiency = module == null || !module.isEnabled() ? MekanismConfig.gear.mekaToolBaseEfficiency.get() : ((ModuleExcavationEscalationUnit)module.getCustomInstance()).getEfficiency();
        return destroyEnergy.multiply(efficiency);
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlot slot, @Nonnull ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND ? this.attributes : super.getAttributeModifiers(slot, stack);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        IModule module;
        ItemStack stack = player.m_21120_(hand);
        if (!world.m_5776_() && (module = this.getModule(stack, MekanismModules.TELEPORTATION_UNIT)) != null && module.isEnabled()) {
            BlockPos pos;
            BlockHitResult result = MekanismUtils.rayTrace(player, MekanismConfig.gear.mekaToolMaxTeleportReach.get());
            if ((!((ModuleTeleportationUnit)module.getCustomInstance()).requiresBlockTarget() || result.m_6662_() != HitResult.Type.MISS) && this.isValidDestinationBlock(world, (pos = result.m_82425_()).m_7494_()) && this.isValidDestinationBlock(world, pos.m_6630_(2))) {
                double distance = player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                if (distance < 5.0) {
                    return InteractionResultHolder.m_19098_((Object)stack);
                }
                IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                FloatingLong energyNeeded = ((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageTeleport.get()).multiply(distance / 10.0);
                if (energyContainer == null || energyContainer.getEnergy().smallerThan(energyNeeded)) {
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
                energyContainer.extract(energyNeeded, Action.EXECUTE, AutomationType.MANUAL);
                if (player.m_20159_()) {
                    player.m_8127_();
                }
                player.m_6021_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5);
                player.f_19789_ = 0.0f;
                Mekanism.packetHandler().sendToAllTracking(new PacketPortalFX(pos.m_7494_()), world, pos);
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private boolean isValidDestinationBlock(Level world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        return blockState.m_60795_() || blockState.m_60734_() instanceof LiquidBlock || blockState.m_60734_() instanceof IFluidBlock;
    }

    public int getDefaultTooltipHideFlags(@Nonnull ItemStack stack) {
        return super.getDefaultTooltipHideFlags(stack) | ItemStack.TooltipPart.MODIFIERS.m_41809_();
    }

    public boolean m_8120_(@Nonnull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    @Override
    public boolean supportsSlotType(ItemStack stack, @Nonnull EquipmentSlot slotType) {
        return IModeItem.super.supportsSlotType(stack, slotType) && this.getModules(stack).stream().anyMatch(Module::handlesModeChange);
    }

    @Override
    public void changeMode(@Nonnull Player player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
        for (Module module : this.getModules(stack)) {
            if (!module.handlesModeChange()) continue;
            module.changeMode(player, stack, shift, displayChangeMessage);
            return;
        }
    }

    @Override
    protected FloatingLong getMaxEnergy(ItemStack stack) {
        IModule module = this.getModule(stack, MekanismModules.ENERGY_UNIT);
        return module == null ? (FloatingLong)MekanismConfig.gear.mekaToolBaseEnergyCapacity.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getEnergyCapacity(module);
    }

    @Override
    protected FloatingLong getChargeRate(ItemStack stack) {
        IModule module = this.getModule(stack, MekanismModules.ENERGY_UNIT);
        return module == null ? (FloatingLong)MekanismConfig.gear.mekaToolBaseChargeRate.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getChargeRate(module);
    }
}

