/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Upgrade;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.chunkloading.IChunkLoader;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.base.TileEntityUpdateable;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.world.ForgeChunkManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TileComponentChunkLoader<T extends TileEntityMekanism>
implements ITileComponent {
    private static final Logger LOGGER = LogManager.getLogger((String)"Mekanism TileComponentChunkLoader");
    private final T tile;
    private final LongSet chunkSet = new LongOpenHashSet();
    @Nullable
    private ServerLevel prevWorld;
    @Nullable
    private BlockPos prevPos;
    private boolean hasRegistered;

    public TileComponentChunkLoader(T tile) {
        this.tile = tile;
        ((TileEntityMekanism)this.tile).addComponent(this);
    }

    public boolean canOperate() {
        return MekanismConfig.general.allowChunkloading.get() && ((TileEntityMekanism)this.tile).supportsUpgrades() && ((TileEntityMekanism)this.tile).getComponent().isUpgradeInstalled(Upgrade.ANCHOR);
    }

    private void releaseChunkTickets(@Nonnull ServerLevel world, @Nonnull BlockPos pos) {
        int tickets = this.chunkSet.size();
        LOGGER.debug("Attempting to remove {} chunk tickets. Pos: {} World: {}", (Object)tickets, (Object)pos, (Object)world.m_46472_().m_135782_());
        if (tickets > 0) {
            LongIterator longIterator = this.chunkSet.iterator();
            while (longIterator.hasNext()) {
                long chunkPos = (Long)longIterator.next();
                ForgeChunkManager.forceChunk((ServerLevel)world, (String)"mekanism", (BlockPos)pos, (int)((int)chunkPos), (int)((int)(chunkPos >> 32)), (boolean)false, (boolean)false);
            }
            this.chunkSet.clear();
            this.markDirty();
        }
        this.hasRegistered = false;
        this.prevWorld = null;
    }

    private void registerChunkTickets(@Nonnull ServerLevel world) {
        this.prevPos = this.tile.m_58899_();
        this.prevWorld = world;
        Set<ChunkPos> chunks = ((IChunkLoader)this.tile).getChunkSet();
        int tickets = chunks.size();
        LOGGER.debug("Attempting to add {} chunk tickets. Pos: {} World: {}", (Object)tickets, (Object)this.prevPos, (Object)world.m_46472_().m_135782_());
        if (tickets > 0) {
            for (ChunkPos chunkPos : chunks) {
                ForgeChunkManager.forceChunk((ServerLevel)world, (String)"mekanism", (BlockPos)this.prevPos, (int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (boolean)true, (boolean)false);
                this.chunkSet.add(chunkPos.m_45588_());
            }
            this.markDirty();
        }
        this.hasRegistered = true;
    }

    public void refreshChunkTickets() {
        if (!((TileEntityUpdateable)this.tile).isRemote()) {
            this.refreshChunkTickets((ServerLevel)Objects.requireNonNull(this.tile.m_58904_()), this.tile.m_58899_(), true);
        }
    }

    private void refreshChunkTickets(@Nonnull ServerLevel world, @Nonnull BlockPos pos, boolean ticketsChanged) {
        boolean canOperate = this.canOperate();
        if (this.hasRegistered && this.prevWorld != null && this.prevPos != null) {
            if (this.prevWorld != world || !pos.equals((Object)this.prevPos)) {
                this.releaseChunkTickets(this.prevWorld, this.prevPos);
                if (canOperate) {
                    this.registerChunkTickets(world);
                }
            } else if (!canOperate) {
                this.releaseChunkTickets(world, pos);
            } else if (ticketsChanged) {
                if (this.chunkSet.isEmpty()) {
                    this.registerChunkTickets(world);
                } else {
                    LongSet chunks = this.getTileChunks();
                    if (chunks.isEmpty()) {
                        this.releaseChunkTickets(world, pos);
                    } else {
                        int removed = 0;
                        int added = 0;
                        LongIterator chunkIt = this.chunkSet.iterator();
                        while (chunkIt.hasNext()) {
                            long chunkPos = chunkIt.nextLong();
                            if (chunks.contains(chunkPos)) continue;
                            ForgeChunkManager.forceChunk((ServerLevel)world, (String)"mekanism", (BlockPos)pos, (int)((int)chunkPos), (int)((int)(chunkPos >> 32)), (boolean)false, (boolean)false);
                            chunkIt.remove();
                            ++removed;
                        }
                        LongIterator longIterator = chunks.iterator();
                        while (longIterator.hasNext()) {
                            long chunkPos = (Long)longIterator.next();
                            if (!this.chunkSet.add(chunkPos)) continue;
                            ForgeChunkManager.forceChunk((ServerLevel)world, (String)"mekanism", (BlockPos)pos, (int)((int)chunkPos), (int)((int)(chunkPos >> 32)), (boolean)true, (boolean)false);
                            ++added;
                        }
                        if (removed != 0 || added != 0) {
                            this.markDirty();
                        }
                        LOGGER.debug("Removed {} no longer valid chunk tickets, and added {} newly valid chunk tickets. Pos: {} World: {}", (Object)removed, (Object)added, (Object)pos, (Object)world.m_46472_().m_135782_());
                    }
                }
            }
        } else if (canOperate) {
            this.registerChunkTickets(world);
        }
    }

    public void tickServer() {
        Level world = this.tile.m_58904_();
        if (world != null) {
            this.refreshChunkTickets((ServerLevel)world, this.tile.m_58899_(), false);
        }
    }

    @Override
    public void read(CompoundTag nbtTags) {
        if (!this.chunkSet.isEmpty()) {
            if (this.tile.m_58898_() && !((TileEntityUpdateable)this.tile).isRemote() && this.hasRegistered && this.prevWorld != null && this.prevPos != null) {
                this.releaseChunkTickets(this.prevWorld, this.prevPos);
            } else {
                this.chunkSet.clear();
            }
        }
        for (long chunk : nbtTags.m_128467_("chunkSet")) {
            this.chunkSet.add(chunk);
        }
    }

    @Override
    public void write(CompoundTag nbtTags) {
        nbtTags.m_128388_("chunkSet", this.chunkSet.toLongArray());
    }

    @Override
    public void invalidate() {
        if (!((TileEntityUpdateable)this.tile).isRemote() && this.hasRegistered && this.prevWorld != null && this.prevPos != null) {
            this.releaseChunkTickets(this.prevWorld, this.prevPos);
        }
    }

    private void markDirty() {
        if (this.tile.m_58898_()) {
            WorldUtils.markChunkDirty(this.tile.m_58904_(), this.tile.m_58899_());
        }
    }

    private LongSet getTileChunks() {
        Set<ChunkPos> chunks = ((IChunkLoader)this.tile).getChunkSet();
        if (chunks.isEmpty()) {
            return LongSets.EMPTY_SET;
        }
        LongOpenHashSet chunksAsLongs = new LongOpenHashSet(chunks.size());
        for (ChunkPos chunkPos : chunks) {
            chunksAsLongs.add(chunkPos.m_45588_());
        }
        return chunksAsLongs;
    }

    public static class ChunkValidationCallback
    implements ForgeChunkManager.LoadingValidationCallback {
        public static final ChunkValidationCallback INSTANCE = new ChunkValidationCallback();

        private ChunkValidationCallback() {
        }

        public void validateTickets(@Nonnull ServerLevel world, @Nonnull ForgeChunkManager.TicketHelper ticketHelper) {
            ResourceLocation worldName = world.m_46472_().m_135782_();
            LOGGER.debug("Validating tickets for: {}. Blocks: {}, Entities: {}", (Object)worldName, (Object)ticketHelper.getBlockTickets().size(), (Object)ticketHelper.getEntityTickets().size());
            for (Map.Entry entry : ticketHelper.getBlockTickets().entrySet()) {
                BlockPos pos = (BlockPos)entry.getKey();
                LongSet forcedChunks = (LongSet)((Pair)entry.getValue()).getFirst();
                int ticketCount = forcedChunks.size();
                LOGGER.debug("Validating tickets for: {}, BlockPos: {}, Forced chunks: {}, Ticking forced chunks: {}", (Object)worldName, (Object)pos, (Object)ticketCount, (Object)((LongSet)((Pair)entry.getValue()).getSecond()).size());
                if (ticketCount <= 0) continue;
                BlockEntity tile = world.m_7702_(pos);
                if (tile instanceof IChunkLoader) {
                    TileComponentChunkLoader<?> chunkLoader = ((IChunkLoader)tile).getChunkLoader();
                    if (chunkLoader.canOperate()) {
                        LongSet chunks;
                        if (!forcedChunks.equals(chunkLoader.chunkSet)) {
                            LOGGER.debug("Mismatched chunkSet for chunk loader at position: {} in {}. Correcting.", (Object)pos, (Object)worldName);
                            chunkLoader.chunkSet.clear();
                            chunkLoader.chunkSet.addAll((LongCollection)forcedChunks);
                            chunkLoader.markDirty();
                        }
                        if ((chunks = chunkLoader.getTileChunks()).isEmpty()) {
                            LOGGER.warn("Removing {} chunk tickets as they are no longer valid as this loader does not expect to have any tickets even though it is can operate. Pos: {} World: {}", (Object)ticketCount, (Object)pos, (Object)worldName);
                            this.releaseAllTickets(chunkLoader, pos, ticketHelper);
                            continue;
                        }
                        int removed = 0;
                        int added = 0;
                        LongIterator chunkIt = chunkLoader.chunkSet.iterator();
                        while (chunkIt.hasNext()) {
                            long chunkPos = chunkIt.nextLong();
                            if (chunks.contains(chunkPos)) continue;
                            ticketHelper.removeTicket(pos, chunkPos, false);
                            chunkIt.remove();
                            ++removed;
                        }
                        LongIterator longIterator = chunks.iterator();
                        while (longIterator.hasNext()) {
                            long chunkPos = (Long)longIterator.next();
                            if (!chunkLoader.chunkSet.add(chunkPos)) continue;
                            ForgeChunkManager.forceChunk((ServerLevel)world, (String)"mekanism", (BlockPos)pos, (int)((int)chunkPos), (int)((int)(chunkPos >> 32)), (boolean)true, (boolean)false);
                            ++added;
                        }
                        chunkLoader.hasRegistered = true;
                        chunkLoader.prevWorld = world;
                        chunkLoader.prevPos = pos;
                        if (removed == 0 && added == 0) {
                            LOGGER.debug("Tickets for position: {} in {}, successfully validated.", (Object)pos, (Object)worldName);
                            continue;
                        }
                        chunkLoader.markDirty();
                        LOGGER.info("Removed {} no longer valid chunk tickets, and added {} newly valid chunk tickets. Pos: {} World: {}", (Object)removed, (Object)added, (Object)pos, (Object)worldName);
                        continue;
                    }
                    LOGGER.info("Removing {} chunk tickets as they are no longer valid as this loader cannot operate. Pos: {} World: {}", (Object)ticketCount, (Object)pos, (Object)worldName);
                    this.releaseAllTickets(chunkLoader, pos, ticketHelper);
                    continue;
                }
                LOGGER.warn("Block at {}, in {}, is not a valid chunk loader. Removing {} chunk tickets.", (Object)pos, (Object)worldName, (Object)ticketCount);
                ticketHelper.removeAllTickets(pos);
            }
        }

        private void releaseAllTickets(TileComponentChunkLoader<?> chunkLoader, BlockPos pos, ForgeChunkManager.TicketHelper ticketHelper) {
            ticketHelper.removeAllTickets(pos);
            chunkLoader.chunkSet.clear();
            chunkLoader.hasRegistered = false;
            chunkLoader.prevWorld = null;
            chunkLoader.markDirty();
        }
    }
}

