/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mekanism.api.Upgrade;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.list.SyncableFilterList;
import mekanism.common.lib.collection.HashList;
import mekanism.common.tile.interfaces.IHasSortableFilters;
import mekanism.common.tile.interfaces.ISustainedData;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.tile.qio.TileEntityQIOComponent;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityQIOFilterHandler
extends TileEntityQIOComponent
implements ITileFilterHolder<QIOFilter<?>>,
IHasSortableFilters,
ISustainedData {
    private HashList<QIOFilter<?>> filters = new HashList();

    public TileEntityQIOFilterHandler(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
    }

    @Override
    @ComputerMethod
    public HashList<QIOFilter<?>> getFilters() {
        return this.filters;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (!this.filters.isEmpty()) {
            ListTag filterTags = new ListTag();
            for (QIOFilter<?> filter : this.filters) {
                filterTags.add((Object)filter.write(new CompoundTag()));
            }
            ItemDataUtils.setList(itemStack, "filters", filterTags);
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (ItemDataUtils.hasData(itemStack, "filters", 9)) {
            ListTag tagList = ItemDataUtils.getList(itemStack, "filters");
            for (int i = 0; i < tagList.size(); ++i) {
                IFilter<?> filter = BaseFilter.readFromNBT(tagList.m_128728_(i));
                if (!(filter instanceof QIOFilter)) continue;
                QIOFilter qioFilter = (QIOFilter)filter;
                this.filters.add(qioFilter);
            }
        }
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Object2ObjectOpenHashMap remap = new Object2ObjectOpenHashMap();
        remap.put("filters", "filters");
        return remap;
    }

    @Override
    protected void addGeneralPersistentData(CompoundTag data) {
        super.addGeneralPersistentData(data);
        if (!this.filters.isEmpty()) {
            ListTag filterTags = new ListTag();
            for (QIOFilter<?> filter : this.filters) {
                filterTags.add((Object)filter.write(new CompoundTag()));
            }
            data.m_128365_("filters", (Tag)filterTags);
        }
    }

    @Override
    protected void loadGeneralPersistentData(CompoundTag data) {
        super.loadGeneralPersistentData(data);
        this.filters.clear();
        if (data.m_128425_("filters", 9)) {
            ListTag tagList = data.m_128437_("filters", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                IFilter<?> filter = BaseFilter.readFromNBT(tagList.m_128728_(i));
                if (!(filter instanceof QIOFilter)) continue;
                QIOFilter qioFilter = (QIOFilter)filter;
                this.filters.add(qioFilter);
            }
        }
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableFilterList.create(this::getFilters, value -> {
            HashList filters;
            this.filters = value instanceof HashList ? (filters = (HashList)value) : new HashList(value);
        }));
    }

    @Override
    public void moveUp(int filterIndex) {
        this.filters.swap(filterIndex, filterIndex - 1);
        this.markForSave();
    }

    @Override
    public void moveDown(int filterIndex) {
        this.filters.swap(filterIndex, filterIndex + 1);
        this.markForSave();
    }

    protected int getMaxTransitCount() {
        return 64 + 32 * this.upgradeComponent.getUpgrades(Upgrade.SPEED);
    }

    protected int getMaxTransitTypes() {
        return Math.round(1.0f + (float)this.upgradeComponent.getUpgrades(Upgrade.SPEED) / 2.0f);
    }

    @ComputerMethod
    private boolean addFilter(QIOFilter<?> filter) throws ComputerException {
        this.validateSecurityIsPublic();
        return this.filters.add(filter);
    }

    @ComputerMethod
    private boolean removeFilter(QIOFilter<?> filter) throws ComputerException {
        this.validateSecurityIsPublic();
        return this.filters.remove(filter);
    }
}

