/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ItemDataUtils {
    private ItemDataUtils() {
    }

    @Nonnull
    public static CompoundTag getDataMap(ItemStack stack) {
        ItemDataUtils.initStack(stack);
        return stack.m_41783_().m_128469_("mekData");
    }

    @Nullable
    public static CompoundTag getDataMapIfPresent(ItemStack stack) {
        return ItemDataUtils.hasDataTag(stack) ? ItemDataUtils.getDataMap(stack) : null;
    }

    @Nonnull
    public static CompoundTag getDataMapIfPresentNN(ItemStack stack) {
        return ItemDataUtils.hasDataTag(stack) ? ItemDataUtils.getDataMap(stack) : new CompoundTag();
    }

    public static boolean hasData(ItemStack stack, String key, int type) {
        return ItemDataUtils.hasDataTag(stack) && ItemDataUtils.getDataMap(stack).m_128425_(key, type);
    }

    public static boolean hasUUID(ItemStack stack, String key) {
        return ItemDataUtils.hasDataTag(stack) && ItemDataUtils.getDataMap(stack).m_128403_(key);
    }

    public static void removeData(ItemStack stack, String key) {
        if (ItemDataUtils.hasDataTag(stack)) {
            CompoundTag dataMap = ItemDataUtils.getDataMap(stack);
            dataMap.m_128473_(key);
            if (dataMap.m_128456_()) {
                stack.m_41783_().m_128473_("mekData");
            }
        }
    }

    public static <V extends IForgeRegistryEntry<V>> V getRegistryEntry(ItemStack stack, String key, IForgeRegistry<V> registry, V fallback) {
        return ItemDataUtils.hasDataTag(stack) ? NBTUtils.readRegistryEntry(ItemDataUtils.getDataMap(stack), key, registry, fallback) : fallback;
    }

    public static int getInt(ItemStack stack, String key) {
        return ItemDataUtils.hasDataTag(stack) ? ItemDataUtils.getDataMap(stack).m_128451_(key) : 0;
    }

    public static long getLong(ItemStack stack, String key) {
        return ItemDataUtils.hasDataTag(stack) ? ItemDataUtils.getDataMap(stack).m_128454_(key) : 0L;
    }

    public static boolean getBoolean(ItemStack stack, String key) {
        return ItemDataUtils.hasDataTag(stack) && ItemDataUtils.getDataMap(stack).m_128471_(key);
    }

    public static double getDouble(ItemStack stack, String key) {
        return ItemDataUtils.hasDataTag(stack) ? ItemDataUtils.getDataMap(stack).m_128459_(key) : 0.0;
    }

    public static String getString(ItemStack stack, String key) {
        return ItemDataUtils.hasDataTag(stack) ? ItemDataUtils.getDataMap(stack).m_128461_(key) : "";
    }

    public static CompoundTag getCompound(ItemStack stack, String key) {
        return ItemDataUtils.hasDataTag(stack) ? ItemDataUtils.getDataMap(stack).m_128469_(key) : new CompoundTag();
    }

    @Nullable
    public static UUID getUniqueID(ItemStack stack, String key) {
        return ItemDataUtils.hasDataTag(stack) ? ItemDataUtils.getDataMap(stack).m_128342_(key) : null;
    }

    public static ListTag getList(ItemStack stack, String key) {
        return ItemDataUtils.hasDataTag(stack) ? ItemDataUtils.getDataMap(stack).m_128437_(key, 10) : new ListTag();
    }

    public static void setInt(ItemStack stack, String key, int i) {
        ItemDataUtils.initStack(stack);
        ItemDataUtils.getDataMap(stack).m_128405_(key, i);
    }

    public static void setLong(ItemStack stack, String key, long l) {
        ItemDataUtils.initStack(stack);
        ItemDataUtils.getDataMap(stack).m_128356_(key, l);
    }

    public static void setBoolean(ItemStack stack, String key, boolean b) {
        ItemDataUtils.initStack(stack);
        ItemDataUtils.getDataMap(stack).m_128379_(key, b);
    }

    public static void setDouble(ItemStack stack, String key, double d) {
        ItemDataUtils.initStack(stack);
        ItemDataUtils.getDataMap(stack).m_128347_(key, d);
    }

    public static void setString(ItemStack stack, String key, String s) {
        ItemDataUtils.initStack(stack);
        ItemDataUtils.getDataMap(stack).m_128359_(key, s);
    }

    public static void setCompound(ItemStack stack, String key, CompoundTag tag) {
        ItemDataUtils.initStack(stack);
        ItemDataUtils.getDataMap(stack).m_128365_(key, (Tag)tag);
    }

    public static void setUUID(ItemStack stack, String key, UUID uuid) {
        ItemDataUtils.initStack(stack);
        ItemDataUtils.getDataMap(stack).m_128362_(key, uuid);
    }

    public static void setList(ItemStack stack, String key, ListTag tag) {
        ItemDataUtils.initStack(stack);
        ItemDataUtils.getDataMap(stack).m_128365_(key, (Tag)tag);
    }

    private static boolean hasDataTag(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128425_("mekData", 10);
    }

    private static void initStack(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128425_("mekData", 10)) {
            tag.m_128365_("mekData", (Tag)new CompoundTag());
        }
    }
}

