/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.client.MekanismClient;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.IOwnerItem;
import mekanism.common.lib.security.ISecurityItem;
import mekanism.common.lib.security.ISecurityObject;
import mekanism.common.lib.security.ISecurityTile;
import mekanism.common.lib.security.SecurityData;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.lib.security.SecurityMode;
import mekanism.common.network.to_client.PacketSecurityUpdate;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;

public final class SecurityUtils {
    private SecurityUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isOp(Player p) {
        if (!(p instanceof ServerPlayer)) return false;
        ServerPlayer player = (ServerPlayer)p;
        if (!MekanismConfig.general.opsBypassRestrictions.get()) return false;
        if (!player.f_8924_.m_6846_().m_11303_(player.m_36316_())) return false;
        return true;
    }

    public static boolean canAccess(Player player, Object object) {
        ISecurityObject security;
        if (object instanceof ItemStack) {
            Item item;
            ItemStack stack = (ItemStack)object;
            if (!(stack.m_41720_() instanceof ISecurityItem) && (item = stack.m_41720_()) instanceof IOwnerItem) {
                IOwnerItem ownerItem = (IOwnerItem)item;
                if (!MekanismConfig.general.allowProtection.get() || SecurityUtils.isOp(player)) {
                    return true;
                }
                UUID owner = ownerItem.getOwnerUUID(stack);
                return owner == null || owner.equals(player.m_142081_());
            }
            security = SecurityUtils.wrapSecurityItem(stack);
        } else if (object instanceof ISecurityObject) {
            ISecurityObject securityObject;
            security = securityObject = (ISecurityObject)object;
        } else {
            return true;
        }
        return !security.hasSecurity() || SecurityUtils.canAccess(security.getSecurityMode(), player, security.getOwnerUUID());
    }

    private static boolean canAccess(SecurityMode mode, Player player, UUID owner) {
        if (!MekanismConfig.general.allowProtection.get() || SecurityUtils.isOp(player)) {
            return true;
        }
        if (owner == null || player.m_142081_().equals(owner)) {
            return true;
        }
        SecurityFrequency freq = SecurityUtils.getFrequency(owner);
        if (freq == null) {
            return true;
        }
        if (freq.isOverridden()) {
            mode = freq.getSecurityMode();
        }
        if (mode == SecurityMode.PUBLIC) {
            return true;
        }
        if (mode == SecurityMode.TRUSTED) {
            return freq.getTrustedUUIDs().contains(player.m_142081_());
        }
        return false;
    }

    @Nullable
    public static SecurityFrequency getFrequency(@Nullable UUID uuid) {
        return uuid == null ? null : FrequencyType.SECURITY.getManager(null).getFrequency(uuid);
    }

    public static void displayNoAccess(Player player) {
        player.m_6352_(MekanismUtils.logFormat(EnumColor.RED, MekanismLang.NO_ACCESS), Util.f_137441_);
    }

    public static SecurityMode getSecurity(ISecurityObject security, Dist side) {
        SecurityData data;
        if (!security.hasSecurity()) {
            return SecurityMode.PUBLIC;
        }
        if (side.isDedicatedServer()) {
            SecurityFrequency freq;
            if (security instanceof ISecurityTile) {
                ISecurityTile securityTile = (ISecurityTile)security;
                freq = securityTile.getSecurity().getFrequency();
            } else {
                freq = SecurityUtils.getFrequency(security.getOwnerUUID());
            }
            if (freq != null && freq.isOverridden()) {
                return freq.getSecurityMode();
            }
        } else if (side.isClient() && (data = MekanismClient.clientSecurityMap.get(security.getOwnerUUID())) != null && data.override) {
            return data.mode;
        }
        return security.getSecurityMode();
    }

    public static boolean isOverridden(ISecurityObject security, Dist side) {
        if (!security.hasSecurity() || security.getOwnerUUID() == null) {
            return false;
        }
        if (side.isDedicatedServer()) {
            SecurityFrequency freq = SecurityUtils.getFrequency(security.getOwnerUUID());
            return freq != null && freq.isOverridden();
        }
        SecurityData data = MekanismClient.clientSecurityMap.get(security.getOwnerUUID());
        return data != null && data.override;
    }

    public static void claimItem(Player player, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IOwnerItem) {
            IOwnerItem ownerItem = (IOwnerItem)item;
            ownerItem.setOwnerUUID(stack, player.m_142081_());
            Mekanism.packetHandler().sendToAll(new PacketSecurityUpdate(player.m_142081_(), null));
            player.m_6352_(MekanismUtils.logFormat(MekanismLang.NOW_OWN), Util.f_137441_);
        }
    }

    public static void addSecurityTooltip(@Nonnull ItemStack stack, @Nonnull List<Component> tooltip) {
        Item item = stack.m_41720_();
        if (item instanceof IOwnerItem) {
            IOwnerItem ownerItem = (IOwnerItem)item;
            tooltip.add(OwnerDisplay.of(MekanismUtils.tryGetClientPlayer(), ownerItem.getOwnerUUID(stack)).getTextComponent());
        }
        ISecurityObject securityObject = SecurityUtils.wrapSecurityItem(stack);
        tooltip.add((Component)MekanismLang.SECURITY.translateColored(EnumColor.GRAY, SecurityUtils.getSecurity(securityObject, Dist.CLIENT)));
        if (SecurityUtils.isOverridden(securityObject, Dist.CLIENT)) {
            tooltip.add((Component)MekanismLang.SECURITY_OVERRIDDEN.translateColored(EnumColor.RED, new Object[0]));
        }
    }

    public static ISecurityObject wrapSecurityItem(final @Nonnull ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof ISecurityItem)) {
            return ISecurityObject.NO_SECURITY;
        }
        return new ISecurityObject(){

            @Override
            @Nullable
            public UUID getOwnerUUID() {
                return ((ISecurityItem)stack.m_41720_()).getOwnerUUID(stack);
            }

            @Override
            @Nullable
            public String getOwnerName() {
                UUID ownerUUID = this.getOwnerUUID();
                return ownerUUID == null ? null : MekanismClient.clientUUIDMap.get(ownerUUID);
            }

            @Override
            public SecurityMode getSecurityMode() {
                return ((ISecurityItem)stack.m_41720_()).getSecurity(stack);
            }

            @Override
            public void setSecurityMode(SecurityMode mode) {
                ((ISecurityItem)stack.m_41720_()).setSecurity(stack, mode);
            }
        };
    }

    public static ISecurityObject wrapSecurityItem(final @Nonnull Supplier<ItemStack> stackSupplier) {
        ItemStack stack = stackSupplier.get();
        if (stack.m_41619_() || !(stack.m_41720_() instanceof ISecurityItem)) {
            return ISecurityObject.NO_SECURITY;
        }
        return new ISecurityObject(){

            private ItemStack getAndValidateStack() {
                ItemStack stack = (ItemStack)stackSupplier.get();
                if (stack.m_41619_() || !(stack.m_41720_() instanceof ISecurityItem)) {
                    return ItemStack.f_41583_;
                }
                return stack;
            }

            @Override
            public boolean hasSecurity() {
                return !this.getAndValidateStack().m_41619_();
            }

            @Override
            @Nullable
            public UUID getOwnerUUID() {
                ItemStack stack = this.getAndValidateStack();
                if (stack.m_41619_()) {
                    return null;
                }
                return ((ISecurityItem)stack.m_41720_()).getOwnerUUID(stack);
            }

            @Override
            @Nullable
            public String getOwnerName() {
                UUID ownerUUID = this.getOwnerUUID();
                return ownerUUID == null ? null : MekanismClient.clientUUIDMap.get(ownerUUID);
            }

            @Override
            public SecurityMode getSecurityMode() {
                ItemStack stack = this.getAndValidateStack();
                if (stack.m_41619_()) {
                    return SecurityMode.PUBLIC;
                }
                return ((ISecurityItem)stack.m_41720_()).getSecurity(stack);
            }

            @Override
            public void setSecurityMode(SecurityMode mode) {
                ItemStack stack = this.getAndValidateStack();
                if (!stack.m_41619_()) {
                    ((ISecurityItem)stack.m_41720_()).setSecurity(stack, mode);
                }
            }
        };
    }
}

