/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.ingredients.TypedIngredient;
import mezz.jei.util.ErrorUtil;

public final class Focus<V>
implements IFocus<V>,
IFocusGroup {
    private final RecipeIngredientRole role;
    private final ITypedIngredient<V> value;

    public Focus(RecipeIngredientRole role, ITypedIngredient<V> value) {
        ErrorUtil.checkNotNull(role, "focus role");
        ErrorUtil.checkNotNull(value, "focus value");
        this.role = role;
        this.value = value;
    }

    @Override
    public ITypedIngredient<V> getTypedValue() {
        return this.value;
    }

    @Override
    public V getValue() {
        return this.value.getIngredient();
    }

    @Override
    public IFocus.Mode getMode() {
        return switch (this.role) {
            default -> throw new IncompatibleClassChangeError();
            case RecipeIngredientRole.INPUT, RecipeIngredientRole.CATALYST -> IFocus.Mode.INPUT;
            case RecipeIngredientRole.OUTPUT, RecipeIngredientRole.RENDER_ONLY -> IFocus.Mode.OUTPUT;
        };
    }

    @Override
    public RecipeIngredientRole getRole() {
        return this.role;
    }

    @Override
    public <T> Optional<IFocus<T>> checkedCast(IIngredientType<T> ingredientType) {
        if (this.value.getType() == ingredientType) {
            Focus cast = this;
            return Optional.of(cast);
        }
        return Optional.empty();
    }

    public static <V> Focus<V> checkOne(IFocus<V> focus) {
        if (focus instanceof Focus) {
            return (Focus)focus;
        }
        ErrorUtil.checkNotNull(focus, "focus");
        V value = focus.getValue();
        ErrorUtil.checkNotNull(value, "focus value");
        RegisteredIngredients registeredIngredients = Internal.getRegisteredIngredients();
        IIngredientType<V> ingredientType = registeredIngredients.getIngredientType(value);
        return Focus.createFromApi(registeredIngredients, focus.getRole(), ingredientType, value);
    }

    public static <V> Focus<V> createFromApi(RegisteredIngredients registeredIngredients, RecipeIngredientRole role, IIngredientType<V> ingredientType, V value) {
        Optional typedIngredient = TypedIngredient.createTyped(registeredIngredients, ingredientType, value).flatMap(i -> TypedIngredient.deepCopy(registeredIngredients, i));
        if (typedIngredient.isEmpty()) {
            throw new IllegalArgumentException("Focus value is invalid: " + ErrorUtil.getIngredientInfo(value, ingredientType, registeredIngredients));
        }
        return new Focus<V>(role, (ITypedIngredient)typedIngredient.get());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public List<IFocus<?>> getAllFocuses() {
        return List.of(this);
    }

    @Override
    public Stream<IFocus<?>> getFocuses(RecipeIngredientRole role) {
        if (role == this.role) {
            return Stream.of(this);
        }
        return Stream.empty();
    }

    @Override
    public <T> Stream<IFocus<T>> getFocuses(IIngredientType<T> ingredientType) {
        return this.checkedCast(ingredientType).stream();
    }

    @Override
    public <T> Stream<IFocus<T>> getFocuses(IIngredientType<T> ingredientType, RecipeIngredientRole role) {
        if (role == this.role) {
            return this.getFocuses(ingredientType);
        }
        return Stream.empty();
    }
}

