/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fusion;

import mekanism.api.providers.IBlockProvider;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.dynamic.SyncMapper;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityFusionReactorBlock
extends TileEntityMultiblock<FusionReactorMultiblockData> {
    public TileEntityFusionReactorBlock(BlockPos pos, BlockState state) {
        this((IBlockProvider)GeneratorsBlocks.FUSION_REACTOR_FRAME, pos, state);
    }

    public TileEntityFusionReactorBlock(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
    }

    public FusionReactorMultiblockData createMultiblock() {
        return new FusionReactorMultiblockData(this);
    }

    public MultiblockManager<FusionReactorMultiblockData> getManager() {
        return MekanismGenerators.fusionReactorManager;
    }

    public boolean canBeMaster() {
        return false;
    }

    public void setInjectionRateFromPacket(int rate) {
        FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)this.getMultiblock();
        if (multiblock.isFormed()) {
            multiblock.setInjectionRate(Math.min(98, Math.max(0, rate - rate % 2)));
            this.markForSave();
        }
    }

    public void addFuelTabContainerTrackers(MekanismContainer container) {
        SyncMapper.INSTANCE.setup(container, FusionReactorMultiblockData.class, () -> ((TileEntityFusionReactorBlock)this).getMultiblock(), "fuel");
    }

    public void addHeatTabContainerTrackers(MekanismContainer container) {
        SyncMapper.INSTANCE.setup(container, FusionReactorMultiblockData.class, () -> ((TileEntityFusionReactorBlock)this).getMultiblock(), "heat");
    }
}

