/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.scalar.cutall;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.scalar.cutall.ModConfig;
import net.minecraft.scalar.cutall.ModProperty;
import net.minecraft.scalar.cutall.Packet_mod_CutAll;
import net.minecraft.scalar.cutall.ProxyClient;
import net.minecraft.scalar.cutall.ProxyServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cutallsmp")
public class mod_CutAllSMP {
    public static final String MODID = "CutAllSMP";
    public static final String VERSION = "2.5.2";
    private static final Logger LOGGER = LogManager.getLogger();
    @ModProperty(defaultString="iron_axe, wooden_axe, stone_axe, diamond_axe, golden_axe, netherite_axe")
    public static String itemIds = "iron_axe, wooden_axe, stone_axe, diamond_axe, golden_axe, netherite_axe";
    @ModProperty(defaultString="oak_log,spruce_log,birch_log,jungle_log,acacia_log,dark_oak_log,stripped_spruce_log,stripped_birch_log,stripped_jungle_log,stripped_acacia_log,stripped_dark_oak_log,stripped_oak_log,oak_wood,spruce_wood,birch_wood,jungle_wood,acacia_wood,dark_oak_wood,stripped_oak_wood,stripped_spruce_wood,stripped_birch_wood,stripped_jungle_wood,stripped_acacia_wood,stripped_dark_oak_wood,crimson_stem,warped_stem,crimson_hyphae,warped_hyphae")
    public static String blockIds = "oak_log,spruce_log,birch_log,jungle_log,acacia_log,dark_oak_log,stripped_spruce_log,stripped_birch_log,stripped_jungle_log,stripped_acacia_log,stripped_dark_oak_log,stripped_oak_log,oak_wood,spruce_wood,birch_wood,jungle_wood,acacia_wood,dark_oak_wood,stripped_oak_wood,stripped_spruce_wood,stripped_birch_wood,stripped_jungle_wood,stripped_acacia_wood,stripped_dark_oak_wood,crimson_stem,warped_stem,crimson_hyphae,warped_hyphae";
    @ModProperty(defaultString="oak_leaves,spruce_leaves,birch_leaves,jungle_leaves,acacia_leaves,dark_oak_leaves")
    public static String leavesIds = "oak_leaves,spruce_leaves,birch_leaves,jungle_leaves,acacia_leaves,dark_oak_leaves";
    @ModProperty
    public static String nondestructiveItemIDs = "";
    @ModProperty(defaultInt=3)
    public static int leavesRange = 3;
    @ModProperty(defaultString="KEY_C")
    public static String Key = "KEY_C";
    @ModProperty
    public static int Limiter = 0;
    @ModProperty(comment="0:not decrease durability 1,2:decrease durability(1=until whole blocks 2=until break an item)")
    public static int Durability = 0;
    @ModProperty(defaultBoolean=true)
    public static boolean DropGather = true;
    @ModProperty
    public static boolean DestroyUnder = false;
    @ModProperty(defaultBoolean=true)
    public static boolean StartMode = true;
    @ModProperty(defaultString="mod_cutall")
    public static String channelName = "mod_cutall";
    public static boolean dropleaves = true;
    int key_no = 0;
    int flag_change = 0;
    final int FLAG_CHANGE_NUM = 10;
    static List<Object> _itemIds = null;
    static List<Object> _blockIds = null;
    static List<Object> _leavesIds = null;
    static final BlockingQueue<Packet_mod_CutAll> attackHistory = new LinkedBlockingQueue<Packet_mod_CutAll>();
    static final long attackHistoryDelayNanoTime = 3000000000L;
    static final BlockingQueue<Packet_mod_CutAll> _serverPacket = new LinkedBlockingQueue<Packet_mod_CutAll>();
    static mod_CutAllSMP _mod;
    final Object _client = DistExecutor.unsafeRunForDist(() -> ProxyClient::new, () -> ProxyServer::new);

    public mod_CutAllSMP() {
        _mod = this;
        ModConfig.configure(this.getClass(), FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        EventNetworkChannel e = NetworkRegistry.newEventChannel((ResourceLocation)new ResourceLocation(channelName), () -> "0.1", s -> true, s -> true);
        e.addListener(this::onServerPacket);
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    void reloadConfigData() {
        _itemIds = mod_CutAllSMP.idStringToArray(itemIds, false);
        _blockIds = mod_CutAllSMP.idStringToArray(blockIds, true);
        _leavesIds = mod_CutAllSMP.idStringToArray(leavesIds, true);
        dropleaves = leavesIds.length() >= 1;
        this.key_no = ModConfig.getKeyboardNo(Key);
    }

    public <T extends NetworkEvent> void onServerPacket(T event) {
        if (ModConfig.checkAndReload()) {
            _itemIds = null;
        }
        if (null == _itemIds) {
            this.reloadConfigData();
        }
        Packet_mod_CutAll p = new Packet_mod_CutAll();
        NetworkEvent.Context con = (NetworkEvent.Context)event.getSource().get();
        p._player = con.getSender();
        ByteBuf bbPayload = event.getPayload().asReadOnly();
        byte[] payload = new byte[bbPayload.capacity()];
        bbPayload.getBytes(0, payload);
        p.readPacketData(payload);
        if (p._player.m_20275_((double)p._pos.m_123341_(), (double)p._pos.m_123342_(), (double)p._pos.m_123343_()) > 36.0) {
            return;
        }
        _serverPacket.offer(p);
    }

    @SubscribeEvent
    public void tickEventServer(TickEvent.ServerTickEvent event) {
        if (!TickEvent.Phase.END.equals((Object)event.phase)) {
            return;
        }
        Packet_mod_CutAll p = (Packet_mod_CutAll)_serverPacket.poll();
        if (null == p) {
            return;
        }
        mod_CutAllSMP.startCut(p, p._player);
    }

    protected static void startCut(Packet_mod_CutAll p, Player player) {
        Level world = player.m_20193_();
        if (mod_CutAllSMP.canCut(player, p)) {
            mod_CutAllSMP.breakAll(world, player, p);
            if (DropGather) {
                mod_CutAllSMP.stackItem(world, player, p);
            }
        }
    }

    private static boolean canCut(Player player, Packet_mod_CutAll p) {
        Block block = p.blockID;
        BlockState blockState = player.m_20193_().m_8055_(p._pos);
        p.itemstack = player.m_21205_();
        if (p.itemstack == null) {
            return false;
        }
        if (block == null || Blocks.f_50016_ == block) {
            return false;
        }
        if (mod_CutAllSMP.isIdInList(p.itemstack.m_41720_(), _itemIds) && player.m_36298_(blockState)) {
            return mod_CutAllSMP.isIdInList(block, _blockIds);
        }
        return false;
    }

    private static void stackItem(Level world, Player entityplayer, Packet_mod_CutAll p) {
        List list = world.m_45933_((Entity)entityplayer, new AABB((double)p._pos.m_123341_(), (double)p._pos.m_123342_(), (double)p._pos.m_123343_(), (double)p._pos.m_123341_() + 1.0, (double)p._pos.m_123342_() + 1.0, (double)p._pos.m_123343_() + 1.0));
        if (list == null || list.isEmpty()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Entity entity1 = (Entity)list.get(i);
            if (!(entity1 instanceof ItemEntity) || !entity1.m_6084_()) continue;
            ItemEntity e1 = (ItemEntity)entity1;
            ItemStack e1Item = e1.m_32055_();
            int itemDamage = e1Item.m_41773_();
            for (int j = i + 1; j < list.size(); ++j) {
                Entity entity2 = (Entity)list.get(j);
                if (!(entity2 instanceof ItemEntity) || !entity2.m_6084_()) continue;
                ItemEntity e2 = (ItemEntity)entity2;
                ItemStack e2Item = e2.m_32055_();
                int itemDamage1 = e2Item.m_41773_();
                if (e1Item.m_41720_() != e2Item.m_41720_() || itemDamage != itemDamage1) continue;
                e1Item.m_41769_(e2Item.m_41613_());
                entity2.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            e1.m_32045_(e1Item);
        }
    }

    private static void moveItemEntity(Level world, Player entityplayer, BlockPos from, BlockPos to) {
        List list = world.m_45933_((Entity)entityplayer, new AABB((double)from.m_123341_(), (double)from.m_123342_(), (double)from.m_123343_(), (double)(from.m_123341_() + 1), (double)(from.m_123342_() + 1), (double)(from.m_123343_() + 1)));
        if (null == list || list.isEmpty()) {
            return;
        }
        for (Object o : list) {
            Entity e = (Entity)o;
            if (!(e instanceof ItemEntity) || !e.m_6084_()) continue;
            e.m_6034_((double)to.m_123341_(), (double)to.m_123342_(), (double)to.m_123343_());
        }
    }

    private static void breakAll(Level world, Player player, Packet_mod_CutAll p) {
        if (dropleaves) {
            mod_CutAllSMP.checkLeaves(world, player, p._pos, p);
        }
        mod_CutAllSMP.checkConnection(world, p._pos, p);
        while (mod_CutAllSMP.breakBlock(world, player, p)) {
        }
        p.position.clear();
    }

    private static void checkConnection(Level world, BlockPos pos, Packet_mod_CutAll p) {
        int is = 1;
        int ie = 1;
        int js = 1;
        int je = 1;
        int ks = 1;
        int ke = 1;
        if (Limiter != 0) {
            if (p._pos.m_123341_() - Limiter / 2 == pos.m_123341_()) {
                is = 0;
            }
            if (p._pos.m_123341_() + Limiter / 2 == pos.m_123341_()) {
                ie = 0;
            }
            if (p._pos.m_123342_() - Limiter / 2 == pos.m_123342_()) {
                js = 0;
            }
            if (p._pos.m_123342_() + Limiter / 2 == pos.m_123342_()) {
                je = 0;
            }
            if (p._pos.m_123343_() - Limiter / 2 == pos.m_123343_()) {
                ks = 0;
            }
            if (p._pos.m_123343_() + Limiter / 2 == pos.m_123343_()) {
                ke = 0;
            }
        }
        if (!DestroyUnder && p._pos.m_123342_() == pos.m_123342_()) {
            js = 0;
        }
        for (int i2 = -is; i2 <= ie; ++i2) {
            for (int j2 = -js; j2 <= je; ++j2) {
                for (int k2 = -ks; k2 <= ke; ++k2) {
                    BlockState blockID1 = world.m_8055_(pos.m_142082_(i2, j2, k2));
                    if (!mod_CutAllSMP.checkBlock(blockID1.m_60734_(), p)) continue;
                    p.position.offer(pos.m_142082_(i2, j2, k2));
                }
            }
        }
    }

    private static boolean breakBlock(Level world, Player entityplayer, Packet_mod_CutAll p) {
        EquipmentSlot activehand;
        BlockPos pos = p.position.poll();
        if (pos == null) {
            return false;
        }
        BlockState block1 = world.m_8055_(pos);
        EquipmentSlot equipmentSlot = activehand = InteractionHand.OFF_HAND == entityplayer.m_7655_() ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
        if (mod_CutAllSMP.checkBlock(block1.m_60734_(), p)) {
            if ((1 == Durability || 2 == Durability) && null != entityplayer.m_6844_(activehand)) {
                p.itemstack.m_41686_(world, block1, pos, entityplayer);
                if (p.itemstack.m_41613_() <= 0) {
                    entityplayer.m_8061_(activehand, ItemStack.f_41583_);
                }
            }
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, block1, entityplayer);
            Block block = block1.m_60734_();
            ItemStack itemstack2 = null == entityplayer.m_21205_() ? null : entityplayer.m_21205_().m_41777_();
            block.m_6240_(world, entityplayer, pos, block1, world.m_7702_(pos), itemstack2);
            try {
                if (world instanceof ServerLevel) {
                    block.m_49805_((ServerLevel)world, pos, event.getExpToDrop());
                }
                world.m_7471_(pos, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (DropGather) {
                mod_CutAllSMP.moveItemEntity(world, entityplayer, pos, p._pos);
            }
            if (dropleaves) {
                mod_CutAllSMP.checkLeaves(world, entityplayer, pos, p);
            }
            mod_CutAllSMP.checkConnection(world, pos, p);
            if (2 == Durability && null == entityplayer.m_6844_(activehand)) {
                return false;
            }
        }
        return true;
    }

    private static boolean checkBlock(Block block1, Packet_mod_CutAll p) {
        if (block1 == null || Blocks.f_50016_ == block1) {
            return false;
        }
        return block1 == p.blockID;
    }

    private static void checkLeaves(Level world, Player entityplayer, BlockPos pos, Packet_mod_CutAll p) {
        for (int i2 = -leavesRange; i2 <= leavesRange; ++i2) {
            for (int j2 = -leavesRange; j2 <= leavesRange; ++j2) {
                for (int k2 = -leavesRange; k2 <= leavesRange; ++k2) {
                    BlockPos pos2 = pos.m_142082_(i2, j2, k2);
                    BlockState block1 = world.m_8055_(pos2);
                    Block block = block1.m_60734_();
                    if (block1 == null || !mod_CutAllSMP.isIdInList(block, _leavesIds)) continue;
                    ItemStack itemstack2 = null == entityplayer.m_21205_() ? null : entityplayer.m_21205_().m_41777_();
                    BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos2, block1, entityplayer);
                    block.m_6240_(world, entityplayer, pos2, block1, world.m_7702_(pos2), itemstack2);
                    if (world instanceof ServerLevel) {
                        block.m_49805_((ServerLevel)world, pos2, event.getExpToDrop());
                    }
                    world.m_7471_(pos2, false);
                    if (!DropGather) continue;
                    mod_CutAllSMP.moveItemEntity(world, entityplayer, pos2, p._pos);
                }
            }
        }
    }

    static boolean isIdInList(Object o, List<Object> list) {
        return null != list && list.indexOf(o) >= 0;
    }

    private static List<Object> idStringToArray(String s, boolean isBlock) {
        try {
            String[] ss;
            ArrayList<Object> l = new ArrayList<Object>();
            for (String string : ss = s.split(",")) {
                Object b = null;
                String string2 = string.trim();
                if (string2.isEmpty()) continue;
                Object object = b = isBlock ? Registry.f_122824_.m_7745_(new ResourceLocation(string2)) : Registry.f_122827_.m_7745_(new ResourceLocation(string2));
                if (Blocks.f_50016_ == b || Items.f_41852_ == b) {
                    String string3 = "minecraft:" + string2;
                    Object object2 = b = isBlock ? Registry.f_122824_.m_7745_(new ResourceLocation(string3)) : Registry.f_122827_.m_7745_(new ResourceLocation(string3));
                }
                if (Blocks.f_50016_ == b || Items.f_41852_ == b) continue;
                l.add(b);
            }
            return l;
        }
        catch (Exception e) {
            LOGGER.error("idStringToArray", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

