/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.netherportalfix;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.PlayerChangedDimensionEvent;
import net.blay09.mods.netherportalfix.ReturnPortalManager;
import net.blay09.mods.netherportalfix.mixin.LivingEntityAccessor;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetherPortalFix {
    public static final String MOD_ID = "netherportalfix";
    public static final Logger logger = LogManager.getLogger();

    public static void initialize() {
        Balm.getEvents().onEvent(PlayerChangedDimensionEvent.class, event -> {
            ServerPlayer player = event.getPlayer();
            ResourceKey fromDim = event.getFromDim();
            ResourceKey toDim = event.getToDim();
            ResourceKey OVERWORLD = Level.f_46428_;
            ResourceKey THE_NETHER = Level.f_46429_;
            if (fromDim == OVERWORLD && toDim == THE_NETHER || fromDim == THE_NETHER && toDim == OVERWORLD) {
                BlockUtil.FoundRectangle fromPortal = ReturnPortalManager.findPortalAt((Player)player, (ResourceKey<Level>)fromDim, ((LivingEntityAccessor)player).getLastPos());
                BlockPos toPos = player.m_142538_();
                if (fromPortal != null) {
                    ReturnPortalManager.storeReturnPortal(player, (ResourceKey<Level>)toDim, toPos, fromPortal);
                    logger.info("Storing return portal from {} to {} in {}", (Object)toDim, (Object)fromPortal.f_124348_, (Object)fromDim);
                } else {
                    logger.info("Not storing return portal because I'm not in a portal.");
                }
            } else {
                logger.info("Not storing return portal because it's from {} to {}", (Object)fromDim, (Object)toDim);
            }
        });
    }
}

