/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.api.mode;

import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.sistr.littlemaidrebirth.api.mode.ItemMatcher;

public class ItemMatchers {
    public static ItemMatcher item(Item item) {
        return new ItemInstance(item);
    }

    public static ItemMatcher name(String name) {
        return new NameMatcher(name);
    }

    public static ItemMatcher tag(TagKey<Item> tag) {
        return new TagMatcher(tag);
    }

    public static ItemMatcher clazz(Class<?> clazz) {
        return new ClassMatcher(clazz);
    }

    private static class ItemInstance
    implements ItemMatcher {
        private final Item item;

        public ItemInstance(Item item) {
            this.item = item;
        }

        @Override
        public boolean isMatch(ItemStack stack) {
            return stack.m_41720_() == this.item;
        }
    }

    private static class NameMatcher
    implements ItemMatcher {
        private final String name;

        public NameMatcher(String name) {
            this.name = name;
        }

        @Override
        public boolean isMatch(ItemStack stack) {
            String itemName = Registry.f_122827_.m_7981_((Object)stack.m_41720_()).toString();
            return this.name.contains(itemName);
        }
    }

    private static class TagMatcher
    implements ItemMatcher {
        private final TagKey<Item> tag;

        public TagMatcher(TagKey<Item> tag) {
            this.tag = tag;
        }

        @Override
        public boolean isMatch(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }
    }

    private static class ClassMatcher
    implements ItemMatcher {
        private final Class<?> clazz;

        public ClassMatcher(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public boolean isMatch(ItemStack stack) {
            Class<?> itemClass = stack.m_41720_().getClass();
            return this.clazz == itemClass || this.clazz.isAssignableFrom(itemClass);
        }
    }
}

