/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.api.mode;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.api.mode.ModeType;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;

public class ModeManager {
    public static ModeManager INSTANCE = new ModeManager();
    private final BiMap<ResourceLocation, ModeType<? extends Mode>> MODE_TYPES = HashBiMap.create();

    public void register(ResourceLocation id, ModeType<? extends Mode> type) {
        this.MODE_TYPES.put((Object)id, type);
    }

    public Optional<ResourceLocation> getId(Mode mode) {
        return Optional.ofNullable((ResourceLocation)this.MODE_TYPES.inverse().get(mode.getModeType()));
    }

    public Collection<Mode> getModes(LittleMaidEntity maid) {
        return this.MODE_TYPES.values().stream().map(type -> type.create(maid)).collect(Collectors.toList());
    }
}

