/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.api.mode;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.world.item.ItemStack;
import net.sistr.littlemaidrebirth.api.mode.ItemMatcher;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;

public class ModeType<T extends Mode> {
    private final BiFunction<ModeType<T>, LittleMaidEntity, T> function;
    private final ImmutableList<ItemMatcher> matchers;

    protected ModeType(BiFunction<ModeType<T>, LittleMaidEntity, T> function, List<ItemMatcher> matchers) {
        this.function = function;
        this.matchers = ImmutableList.copyOf(matchers);
    }

    public T create(LittleMaidEntity maid) {
        return (T)((Mode)this.function.apply(this, maid));
    }

    public boolean isModeItem(ItemStack stack) {
        return this.matchers.stream().anyMatch(matcher -> matcher.isMatch(stack));
    }

    public static <T extends Mode> Builder<T> builder(BiFunction<ModeType<T>, LittleMaidEntity, T> function) {
        return new Builder<T>(function);
    }

    public static class Builder<T extends Mode> {
        private final BiFunction<ModeType<T>, LittleMaidEntity, T> function;
        private final ObjectArrayList<ItemMatcher> matchers = new ObjectArrayList();

        public Builder(BiFunction<ModeType<T>, LittleMaidEntity, T> function) {
            this.function = function;
        }

        public Builder<T> addItemMatcher(ItemMatcher matcher) {
            this.matchers.add((Object)matcher);
            return this;
        }

        public ModeType<T> build() {
            return new ModeType<T>(this.function, (List<ItemMatcher>)this.matchers);
        }
    }
}

