/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.client;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.client.screen.GUIElement;
import net.sistr.littlemaidmodelloader.client.screen.ModelSelectScreen;
import net.sistr.littlemaidmodelloader.client.screen.SoundPackSelectScreen;
import net.sistr.littlemaidrebirth.client.WindowGUIComponent;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.LittleMaidScreenHandler;
import net.sistr.littlemaidrebirth.entity.Tameable;
import net.sistr.littlemaidrebirth.network.OpenIFFScreenPacket;
import net.sistr.littlemaidrebirth.network.SyncBloodSuckPacket;
import net.sistr.littlemaidrebirth.network.SyncMovingStatePacket;

@OnlyIn(value=Dist.CLIENT)
public class LittleMaidScreen
extends AbstractContainerScreen<LittleMaidScreenHandler> {
    private static final ResourceLocation GUI = new ResourceLocation("lmreengaged", "textures/gui/container/littlemaidinventory2.png");
    private static final ResourceLocation SALARY_WINDOW_TEXTURE = new ResourceLocation("littlemaidrebirth", "textures/gui/salary_window.png");
    private static final ResourceLocation ICONS = new ResourceLocation("textures/gui/icons.png");
    private static final ItemStack ARMOR = Items.f_42408_.m_7968_();
    private static final ItemStack BOOK = Items.f_42517_.m_7968_();
    private static final ItemStack NOTE = Items.f_41859_.m_7968_();
    private static final ItemStack FEATHER = Items.f_42402_.m_7968_();
    private static final ItemStack IRON_SWORD = Items.f_42383_.m_7968_();
    private static final ItemStack IRON_AXE = Items.f_42386_.m_7968_();
    private static final ItemStack SUGAR = Items.f_42501_.m_7968_();
    private final LittleMaidEntity owner;
    private final int unpaidDays;
    private WindowGUIComponent salaryWindow;
    private boolean showSalaryWindow;
    private Component stateText;

    public LittleMaidScreen(LittleMaidScreenHandler screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.f_97727_ = 208;
        this.owner = screenContainer.getGuiEntity();
        this.unpaidDays = screenContainer.getUnpaidDays();
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.owner == null) {
            this.f_96541_.m_91152_(null);
            return;
        }
        int left = (int)((float)(this.f_96543_ - this.f_97726_) / 2.0f) - 5;
        int top = (int)((float)(this.f_96544_ - this.f_97727_) / 2.0f);
        int size = 20;
        int layer = -1;
        this.m_142416_((GuiEventListener)new Button(left - size, top + size * ++layer, size, size, (Component)new TextComponent(""), button -> this.owner.getTameOwner().ifPresent(OpenIFFScreenPacket::sendC2SPacket)){

            public void m_6303_(PoseStack matrices, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
                super.m_6303_(matrices, p_renderButton_1_, p_renderButton_2_, p_renderButton_3_);
                LittleMaidScreen.this.f_96542_.m_115123_(BOOK, this.f_93620_ - 8 + this.f_93618_ / 2, this.f_93621_ - 8 + this.f_93619_ / 2);
            }
        });
        this.m_142416_((GuiEventListener)new Button(left - size, top + size * ++layer, size, size, (Component)new TextComponent(""), button -> this.f_96541_.m_91152_((Screen)new SoundPackSelectScreen(this.f_96539_, (Entity)this.owner))){

            public void m_6303_(PoseStack matrices, int x, int y, float delta) {
                super.m_6303_(matrices, x, y, delta);
                LittleMaidScreen.this.f_96542_.m_115123_(NOTE, this.f_93620_ - 8 + this.f_93618_ / 2, this.f_93621_ - 8 + this.f_93619_ / 2);
            }
        });
        this.m_142416_((GuiEventListener)new Button(left - size, top + size * ++layer, size, size, (Component)new TextComponent(""), button -> this.f_96541_.m_91152_((Screen)new ModelSelectScreen(this.f_96539_, this.owner.f_19853_, (Entity)this.owner))){

            public void m_6303_(PoseStack matrices, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
                super.m_6303_(matrices, p_renderButton_1_, p_renderButton_2_, p_renderButton_3_);
                LittleMaidScreen.this.f_96542_.m_115123_(ARMOR, this.f_93620_ - 8 + this.f_93618_ / 2, this.f_93621_ - 8 + this.f_93619_ / 2);
            }
        });
        this.m_142416_((GuiEventListener)new Button(left - size, top + size * ++layer, size, size, (Component)new TextComponent(""), button -> {
            this.owner.setMovingState(this.owner.getMovingState() == Tameable.MovingState.FREEDOM ? Tameable.MovingState.WAIT : Tameable.MovingState.FREEDOM);
            this.stateText = this.getStateText();
        }){

            public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float delta) {
                super.m_6303_(matrices, mouseX, mouseY, delta);
                LittleMaidScreen.this.f_96542_.m_115123_(FEATHER, this.f_93620_ - 8 + this.f_93618_ / 2, this.f_93621_ - 8 + this.f_93619_ / 2);
            }
        });
        this.m_142416_((GuiEventListener)new Button(left - size, top + size * ++layer, size, size, (Component)new TextComponent(""), button -> SyncBloodSuckPacket.sendC2SPacket((Entity)this.owner, !this.owner.isBloodSuck())){

            public void m_6303_(PoseStack matrices, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
                super.m_6303_(matrices, p_renderButton_1_, p_renderButton_2_, p_renderButton_3_);
                LittleMaidScreen.this.f_96542_.m_115123_(LittleMaidScreen.this.owner.isBloodSuck() ? IRON_AXE : IRON_SWORD, this.f_93620_ - 8 + this.f_93618_ / 2, this.f_93621_ - 8 + this.f_93619_ / 2);
            }
        });
        this.salaryWindow = new WindowGUIComponent(this.f_96543_ / 2 - 40, this.f_96544_ / 2 - 40, 80, 80, (Collection)ImmutableList.builder().add((Object)new SalaryGUI(80, 80, this.f_96543_ / 2 - 40, this.f_96544_ / 2 - 40, this.f_96542_, this.f_96547_, 7, this.unpaidDays)).build()){

            @Override
            public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)SALARY_WINDOW_TEXTURE);
                6.m_93133_((PoseStack)matrices, (int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)80, (int)80, (int)128, (int)128);
                super.m_6305_(matrices, mouseX, mouseY, delta);
            }
        };
        this.m_142416_((GuiEventListener)new Button(left - size, top + size * (layer += 2), size, size, (Component)new TextComponent(""), button -> {
            this.showSalaryWindow = true;
        }){

            public void m_6303_(PoseStack matrices, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
                super.m_6303_(matrices, p_renderButton_1_, p_renderButton_2_, p_renderButton_3_);
                LittleMaidScreen.this.f_96542_.m_115123_(SUGAR, this.f_93620_ - 8 + this.f_93618_ / 2, this.f_93621_ - 8 + this.f_93619_ / 2);
            }
        });
        this.stateText = this.getStateText();
    }

    public Component getStateText() {
        TranslatableComponent stateText = new TranslatableComponent("state.littlemaidrebirth." + this.owner.getMovingState().getName());
        this.owner.getModeName().ifPresent(arg_0 -> LittleMaidScreen.lambda$getStateText$6((MutableComponent)stateText, arg_0));
        return stateText;
    }

    public void m_181908_() {
        super.m_181908_();
        this.stateText = this.getStateText();
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrices, mouseX, mouseY, partialTicks);
        this.m_7025_(matrices, mouseX, mouseY);
        InventoryScreen.m_98850_((int)((this.f_96543_ - this.f_97726_) / 2 + 52), (int)((this.f_96544_ - this.f_97727_) / 2 + 59), (int)20, (float)((float)(this.f_96543_ - this.f_97726_) / 2.0f + 52.0f - (float)mouseX), (float)((float)(this.f_96544_ - this.f_97727_) / 2.0f + 30.0f - (float)mouseY), (LivingEntity)this.owner);
        if (this.showSalaryWindow) {
            this.salaryWindow.m_6305_(matrices, mouseX, mouseY, partialTicks);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.showSalaryWindow) {
            if (!this.salaryWindow.m_6375_(mouseX, mouseY, button)) {
                this.showSalaryWindow = false;
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.showSalaryWindow && this.salaryWindow.m_6348_(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.showSalaryWindow && this.salaryWindow.m_7979_(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    protected void m_7027_(PoseStack matrices, int mouseX, int mouseY) {
        RenderSystem.m_69461_();
        this.f_96547_.m_92883_(matrices, this.stateText.getString(), 8.0f, 65.0f, 0x404040);
        String insideSkirt = new TranslatableComponent("entity.littlemaidrebirth.little_maid_mob.InsideSkirt").getString();
        this.f_96547_.m_92883_(matrices, insideSkirt, 168.0f - (float)this.f_96547_.m_92895_(insideSkirt), 65.0f, 0x404040);
        float left = (float)(this.f_96543_ - this.f_97726_) / 2.0f;
        float top = (float)(this.f_96544_ - this.f_97727_) / 2.0f;
        if (left + 7.0f <= (float)mouseX && (float)mouseX < left + 96.0f && top + 7.0f <= (float)mouseY && (float)mouseY < top + 60.0f) {
            this.drawArmor(matrices);
        } else {
            this.drawHealth(matrices, mouseX, mouseY);
        }
    }

    protected void drawHealth(PoseStack matrices, int mouseX, int mouseY) {
        float left = (float)(this.f_96543_ - this.f_97726_) / 2.0f;
        float top = (float)(this.f_96544_ - this.f_97727_) / 2.0f;
        if (left + 98.0f <= (float)mouseX && (float)mouseX < left + 98.0f + 45.0f && top + 7.0f <= (float)mouseY && (float)mouseY < top + 7.0f + 18.0f) {
            String healthStr = Mth.m_14167_((float)this.owner.m_21223_()) + " / " + Mth.m_14167_((float)this.owner.m_21233_());
            float f = 98.0f + (45.0f - (float)this.f_96547_.m_92895_(healthStr)) / 2.0f;
            Objects.requireNonNull(this.f_96547_);
            this.f_96547_.m_92883_(matrices, healthStr, f, 16.0f - 9.0f / 2.0f, 0x404040);
        } else {
            float health = this.owner.m_21223_() / this.owner.m_21233_() * 20.0f;
            this.drawHealth(matrices, 98, 7, Mth.m_14036_((float)(health - 10.0f), (float)0.0f, (float)10.0f), 5);
            this.drawHealth(matrices, 98, 16, Mth.m_14036_((float)health, (float)0.0f, (float)10.0f), 5);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI);
    }

    protected void drawArmor(PoseStack matrices) {
        float armor = this.owner.m_21230_();
        this.drawArmor(matrices, 98, 7, Mth.m_14036_((float)(armor - 10.0f), (float)0.0f, (float)10.0f), 5);
        this.drawArmor(matrices, 98, 16, Mth.m_14036_((float)armor, (float)0.0f, (float)10.0f), 5);
    }

    protected void drawHealth(PoseStack matrices, int x, int y, float health, int rowHeart) {
        this.drawIcon(matrices, x, y, health, rowHeart, 16, 0, 52, 0, 61, 0);
    }

    protected void drawArmor(PoseStack matrices, int x, int y, float health, int rowHeart) {
        this.drawIcon(matrices, x, y, health, rowHeart, 16, 9, 34, 9, 25, 9);
    }

    protected void drawIcon(PoseStack matrices, int x, int y, float num, int row, int baseU, int baseV, int overU, int overV, int halfU, int halfV) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICONS);
        for (int i = 0; i < row; ++i) {
            this.m_93228_(matrices, x + i * 9, y, baseU, baseV, 9, 9);
            if (1.0f < num) {
                this.m_93228_(matrices, x + i * 9, y, overU, overV, 9, 9);
            } else if (0.0f < num) {
                this.m_93228_(matrices, x + i * 9, y, halfU, halfV, 9, 9);
            }
            num -= 2.0f;
        }
    }

    protected void m_7286_(PoseStack matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(matrices, relX, relY, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_7379_() {
        super.m_7379_();
        SyncMovingStatePacket.sendC2SPacket((Entity)this.owner, this.owner.getMovingState());
    }

    private static /* synthetic */ void lambda$getStateText$6(MutableComponent stateText, String modeName) {
        stateText.m_130946_(" : ").m_7220_((Component)new TranslatableComponent("mode.littlemaidrebirth." + modeName));
    }

    public static class SalaryGUI
    extends GUIElement {
        private final ItemRenderer itemRenderer;
        private final Font textRenderer;
        private final int maxUnpaidDays;
        private final int unpaidDays;

        protected SalaryGUI(int width, int height, int x, int y, ItemRenderer itemRenderer, Font textRenderer, int maxUnpaidDays, int unpaidDays) {
            super(width, height);
            this.x = x;
            this.y = y;
            this.itemRenderer = itemRenderer;
            this.textRenderer = textRenderer;
            this.maxUnpaidDays = maxUnpaidDays;
            this.unpaidDays = unpaidDays;
        }

        public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
            matrices.m_85836_();
            RenderSystem.m_69482_();
            String unpaid = this.maxUnpaidDays - this.unpaidDays + " / " + this.maxUnpaidDays;
            int textWidth = this.textRenderer.m_92895_(unpaid);
            matrices.m_85837_(0.0, 0.0, 300.0);
            float f = (float)this.x + (float)this.width / 2.0f - (float)textWidth / 2.0f;
            float f2 = (float)this.y + (float)this.height / 2.0f;
            Objects.requireNonNull(this.textRenderer);
            this.textRenderer.m_92883_(matrices, unpaid, f, f2 - 9.0f / 2.0f, 0);
            matrices.m_85849_();
        }
    }
}

