/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScrollBarComponent
extends GuiComponent {
    protected final Supplier<Float> left;
    protected final Supplier<Float> top;
    protected final Supplier<Float> width;
    protected final Supplier<Float> height;

    public ScrollBarComponent(Supplier<Float> left, Supplier<Float> top, Supplier<Float> width, Supplier<Float> height) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
    }

    public void renderScrollBar(PoseStack matrices, float percent) {
        ScrollBarComponent.fill(matrices, this.left.get().floatValue(), this.top.get().floatValue(), this.left.get().floatValue() + this.width.get().floatValue(), this.top.get().floatValue() + this.height.get().floatValue(), -16777216);
        ScrollBarComponent.fill(matrices, this.left.get().floatValue(), this.top.get().floatValue(), this.left.get().floatValue() + this.width.get().floatValue(), this.top.get().floatValue() + this.height.get().floatValue() * percent, -1);
    }

    public Optional<Float> click(double x, double y) {
        float percent;
        if ((double)this.left.get().floatValue() < x && x < (double)(this.left.get().floatValue() + this.width.get().floatValue()) && 0.0f <= (percent = (float)((y - (double)this.top.get().floatValue()) / (double)this.height.get().floatValue())) && percent <= 1.0f) {
            return Optional.of(Float.valueOf(percent));
        }
        return Optional.empty();
    }

    public static void fill(PoseStack matrices, float x1, float y1, float x2, float y2, int color) {
        ScrollBarComponent.m_93172_((PoseStack)matrices, (int)((int)x1), (int)((int)y1), (int)((int)x2), (int)((int)y2), (int)color);
    }
}

