/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.DataFixer;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.sistr.littlemaidrebirth.entity.FakePlayer;
import net.sistr.littlemaidrebirth.util.LivingAccessor;
import net.sistr.littlemaidrebirth.util.PlayerAccessor;
import net.sistr.littlemaidrebirth.util.PlayerInventoryAccessor;
import org.jetbrains.annotations.Nullable;

public abstract class FakePlayerWrapperEntity<T extends LivingEntity>
extends FakePlayer {
    private static final UUID FPWE_UUID = UUID.fromString("8eabd891-5b4a-44f5-8ea4-89b04100baf6");
    private static final GameProfile FPWE_PROFILE = new GameProfile(FPWE_UUID, "fake_player_name");
    @Nullable
    private static PlayerAdvancements advancementTracker;

    public FakePlayerWrapperEntity(T origin) {
        super((ServerLevel)((LivingEntity)origin).f_19853_, FPWE_PROFILE);
        this.f_8906_ = new FakePlayNetworkHandler(this.m_20194_(), this);
    }

    public static UUID getFPWEUuid() {
        return FPWE_UUID;
    }

    public static Optional<PlayerAdvancements> getFPWEAdvancementTracker() {
        return Optional.ofNullable(advancementTracker);
    }

    public static PlayerAdvancements initFPWEAdvancementTracker(DataFixer dataFixer, PlayerList playerManager, ServerAdvancementManager serverAdvancementLoader, File file, ServerPlayer serverPlayerEntity) {
        if (advancementTracker == null) {
            advancementTracker = new PlayerAdvancements(dataFixer, playerManager, serverAdvancementLoader, file, serverPlayerEntity);
        }
        return advancementTracker;
    }

    public abstract T getOrigin();

    public abstract Optional<PlayerAdvancements> getOriginAdvancementTracker();

    public void m_8119_() {
        ++this.f_20922_;
        ((LivingAccessor)((Object)this)).applyEquipmentAttributes_LM();
        ((LivingAccessor)((Object)this)).tickActiveItemStack_LM();
        this.pickupItems();
        ((PlayerInventoryAccessor)((Object)this)).getPlayerInventory_LMRB().m_36068_();
        this.m_7678_(this.getOrigin().m_20185_(), this.getOrigin().m_20186_(), this.getOrigin().m_20189_(), this.getOrigin().m_146908_(), this.getOrigin().m_146909_());
    }

    protected void pickupItems() {
        if (this.m_21223_() > 0.0f && !this.m_5833_()) {
            AABB box2 = this.m_20159_() && !this.m_20202_().m_146910_() ? this.m_142469_().m_82367_(this.m_20202_().m_142469_()).m_82377_(1.0, 0.0, 1.0) : this.m_142469_().m_82377_(1.0, 0.5, 1.0);
            List list = this.f_19853_.m_45933_((Entity)this, box2);
            ArrayList list2 = Lists.newArrayList();
            for (Entity entity : list) {
                if (entity.m_6095_() == EntityType.f_20570_) {
                    list2.add(entity);
                    continue;
                }
                if (entity.m_146910_()) continue;
                ((PlayerAccessor)((Object)this)).onCollideWithEntity_LM(entity);
            }
            if (!list2.isEmpty()) {
                ((PlayerAccessor)((Object)this)).onCollideWithEntity_LM((Entity)Util.m_143804_((List)list2, (Random)this.f_19796_));
            }
        }
    }

    public void m_7938_(Entity item, int count) {
        this.getOrigin().m_7938_(item, count);
    }

    public PlayerAdvancements m_8960_() {
        return this.getOriginAdvancementTracker().orElse(super.m_8960_());
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.getOrigin().m_6972_(pose);
    }

    public int m_142049_() {
        int id = this.getOrigin().m_142049_();
        if (super.m_142049_() != id) {
            this.m_20234_(id);
        }
        return id;
    }

    public UUID m_142081_() {
        UUID uuid = this.getOrigin().m_142081_();
        if (super.m_142081_() != uuid) {
            this.m_20084_(uuid);
        }
        return uuid;
    }

    public String m_20149_() {
        return this.getOrigin().m_20149_();
    }

    public Vec3 m_20182_() {
        Vec3 vec = this.getOrigin().m_20182_();
        this.m_20343_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
        return vec;
    }

    public double m_20188_() {
        return this.getOrigin().m_20188_();
    }

    public BlockPos m_142538_() {
        return this.getOrigin().m_142538_();
    }

    public AABB m_21270_(Pose pose) {
        return this.getOrigin().m_21270_(pose);
    }

    public void m_5634_(float amount) {
        this.getOrigin().m_5634_(amount);
    }

    public float m_21223_() {
        return this.getOrigin().m_21223_();
    }

    public void m_21153_(float health) {
        this.getOrigin().m_21153_(health);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return this.getOrigin().m_6469_(source, amount);
    }

    public static class FakePlayNetworkHandler
    extends ServerGamePacketListenerImpl {
        public FakePlayNetworkHandler(MinecraftServer server, ServerPlayer playerIn) {
            super(server, (Connection)new FakeClientConnection(), playerIn);
        }

        public void m_141995_(Packet<?> packet) {
        }

        public void m_9831_(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> listener) {
        }
    }

    public static class FakeClientConnection
    extends Connection {
        public FakeClientConnection() {
            super(PacketFlow.SERVERBOUND);
        }

        public void m_129512_(Packet<?> packet) {
        }

        public void m_129514_(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> callback) {
        }
    }
}

