/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity;

import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.sistr.littlemaidrebirth.entity.Contractable;
import net.sistr.littlemaidrebirth.entity.InventorySupplier;

public class ItemContractable<T extends LivingEntity>
implements Contractable {
    private final T mob;
    private final int maxConsumeInterval;
    private final int maxUnpaidTimes;
    private final Predicate<ItemStack> salaryItems;
    private int consumeInterval;
    private int unpaidTimes;
    private boolean contract;
    private boolean strike;

    public ItemContractable(T mob, int maxConsumeInterval, int maxUnpaidTimes, Predicate<ItemStack> salaryItems) {
        this.mob = mob;
        this.maxConsumeInterval = maxConsumeInterval;
        this.maxUnpaidTimes = maxUnpaidTimes;
        this.salaryItems = salaryItems;
    }

    public void tick() {
        if (((LivingEntity)this.mob).f_19853_.m_5776_() || !this.contract) {
            return;
        }
        ++this.consumeInterval;
        if ((this.mob.m_142049_() + ((LivingEntity)this.mob).f_19797_) % 20 != 0) {
            return;
        }
        if (this.maxConsumeInterval < this.consumeInterval) {
            this.consumeInterval = 0;
            ++this.unpaidTimes;
        }
        if (this.strike) {
            return;
        }
        if (0 < this.unpaidTimes) {
            this.receiveSalary(((InventorySupplier)this.mob).getInventory());
            if (this.maxUnpaidTimes < this.unpaidTimes) {
                this.strike = true;
            }
        }
    }

    public boolean isSalary(ItemStack stack) {
        return this.salaryItems.test(stack);
    }

    public void receiveSalary(Container inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            while (!stack.m_41619_() && 0 < this.unpaidTimes && this.salaryItems.test(stack)) {
                --this.unpaidTimes;
                stack.m_41774_(1);
            }
        }
    }

    public void setUnpaidTimes(int unpaidTimes) {
        this.unpaidTimes = unpaidTimes;
    }

    public int getUnpaidTimes() {
        return this.unpaidTimes;
    }

    @Override
    public boolean isContract() {
        return this.contract;
    }

    @Override
    public void setContract(boolean isContract) {
        this.contract = isContract;
    }

    @Override
    public boolean isStrike() {
        return this.strike;
    }

    @Override
    public void setStrike(boolean strike) {
        this.strike = strike;
    }

    @Override
    public void writeContractable(CompoundTag nbt) {
        CompoundTag itemContractable = new CompoundTag();
        itemContractable.m_128379_("contract", this.contract);
        itemContractable.m_128379_("strike", this.strike);
        itemContractable.m_128405_("consumeInterval", this.consumeInterval);
        nbt.m_128365_("ItemContractable", (Tag)itemContractable);
    }

    @Override
    public void readContractable(CompoundTag nbt) {
        if (!nbt.m_128441_("ItemContractable")) {
            return;
        }
        CompoundTag itemContractable = nbt.m_128469_("ItemContractable");
        this.contract = itemContractable.m_128471_("contract");
        this.strike = itemContractable.m_128471_("strike");
        this.consumeInterval = itemContractable.m_128451_("consumeInterval");
    }
}

