/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity;

import com.google.common.collect.Lists;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;
import net.sistr.littlemaidmodelloader.entity.compound.MultiModelCompound;
import net.sistr.littlemaidmodelloader.entity.compound.SoundPlayable;
import net.sistr.littlemaidmodelloader.entity.compound.SoundPlayableCompound;
import net.sistr.littlemaidmodelloader.maidmodel.IModelCaps;
import net.sistr.littlemaidmodelloader.multimodel.IMultiModel;
import net.sistr.littlemaidmodelloader.multimodel.layer.MMPose;
import net.sistr.littlemaidmodelloader.network.CustomMobSpawnPacket;
import net.sistr.littlemaidmodelloader.network.util.CustomPacketEntity;
import net.sistr.littlemaidmodelloader.resource.holder.ConfigHolder;
import net.sistr.littlemaidmodelloader.resource.holder.TextureHolder;
import net.sistr.littlemaidmodelloader.resource.manager.LMConfigManager;
import net.sistr.littlemaidmodelloader.resource.manager.LMModelManager;
import net.sistr.littlemaidmodelloader.resource.manager.LMTextureManager;
import net.sistr.littlemaidmodelloader.resource.util.TextureColors;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.api.mode.ModeManager;
import net.sistr.littlemaidrebirth.config.LMRBConfig;
import net.sistr.littlemaidrebirth.entity.AimingPoseable;
import net.sistr.littlemaidrebirth.entity.Contractable;
import net.sistr.littlemaidrebirth.entity.FakePlayer;
import net.sistr.littlemaidrebirth.entity.FakePlayerSupplier;
import net.sistr.littlemaidrebirth.entity.FixedMoveControl;
import net.sistr.littlemaidrebirth.entity.InventorySupplier;
import net.sistr.littlemaidrebirth.entity.ItemContractable;
import net.sistr.littlemaidrebirth.entity.LMFakePlayerSupplier;
import net.sistr.littlemaidrebirth.entity.LMInventorySupplier;
import net.sistr.littlemaidrebirth.entity.LMScreenHandlerFactory;
import net.sistr.littlemaidrebirth.entity.LittleMaidModelCaps;
import net.sistr.littlemaidrebirth.entity.Tameable;
import net.sistr.littlemaidrebirth.entity.goal.FollowAtHeldItemGoal;
import net.sistr.littlemaidrebirth.entity.goal.FollowTameOwnerGoal;
import net.sistr.littlemaidrebirth.entity.goal.FreedomGoal;
import net.sistr.littlemaidrebirth.entity.goal.HealMyselfGoal;
import net.sistr.littlemaidrebirth.entity.goal.MoveToDropItemGoal;
import net.sistr.littlemaidrebirth.entity.goal.PredicateRevengeGoal;
import net.sistr.littlemaidrebirth.entity.goal.StartPredicateGoalWrapper;
import net.sistr.littlemaidrebirth.entity.goal.TameableStareAtHeldItemGoal;
import net.sistr.littlemaidrebirth.entity.goal.TeleportTameOwnerGoal;
import net.sistr.littlemaidrebirth.entity.goal.WaitGoal;
import net.sistr.littlemaidrebirth.entity.iff.HasIFF;
import net.sistr.littlemaidrebirth.entity.iff.IFF;
import net.sistr.littlemaidrebirth.entity.iff.IFFTag;
import net.sistr.littlemaidrebirth.entity.mode.ModeController;
import net.sistr.littlemaidrebirth.entity.mode.ModeSupplier;
import net.sistr.littlemaidrebirth.entity.mode.ModeWrapperGoal;
import net.sistr.littlemaidrebirth.item.IFFCopyBookItem;
import net.sistr.littlemaidrebirth.setup.Registration;
import net.sistr.littlemaidrebirth.tags.LMTags;
import net.sistr.littlemaidrebirth.util.LivingAccessor;
import net.sistr.littlemaidrebirth.util.ReachAttributeUtil;
import org.jetbrains.annotations.Nullable;

public class LittleMaidEntity
extends TamableAnimal
implements CustomPacketEntity,
InventorySupplier,
Tameable,
Contractable,
ModeSupplier,
HasIFF,
AimingPoseable,
FakePlayerSupplier,
IHasMultiModel,
SoundPlayable {
    private static final EntityDataAccessor<Byte> MOVING_STATE = SynchedEntityData.m_135353_(LittleMaidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<String> MODE_NAME = SynchedEntityData.m_135353_(LittleMaidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> AIMING = SynchedEntityData.m_135353_(LittleMaidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BEGGING = SynchedEntityData.m_135353_(LittleMaidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BLOOD_SUCK = SynchedEntityData.m_135353_(LittleMaidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final LMFakePlayerSupplier fakePlayer = new LMFakePlayerSupplier(this);
    private final LMInventorySupplier littleMaidInventory = new LMInventorySupplier((LivingEntity)this, this);
    private final ItemContractable<LittleMaidEntity> itemContractable = new ItemContractable<LittleMaidEntity>(this, 24000, 7, stack -> stack.m_204117_(LMTags.Items.MAIDS_SALARY));
    private final ModeController modeController = new ModeController((LivingEntity)this, this, new HashSet<Mode>());
    private final MultiModelCompound multiModel;
    private final SoundPlayableCompound soundPlayer;
    private final LMScreenHandlerFactory screenFactory = new LMScreenHandlerFactory(this);
    private final IModelCaps caps = new LittleMaidModelCaps(this);
    private BlockPos freedomPos;
    @OnlyIn(value=Dist.CLIENT)
    private float interestedAngle;
    @OnlyIn(value=Dist.CLIENT)
    private float prevInterestedAngle;

    public LittleMaidEntity(EntityType<LittleMaidEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new FixedMoveControl((Mob)this);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.multiModel = new MultiModelCompound((LivingEntity)this, (TextureHolder)LMTextureManager.INSTANCE.getTexture("Default").orElseThrow(() -> new IllegalStateException("\u30c7\u30d5\u30a9\u30eb\u30c8\u30c6\u30af\u30b9\u30c1\u30e3\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002")), (TextureHolder)LMTextureManager.INSTANCE.getTexture("Default").orElseThrow(() -> new IllegalStateException("\u30c7\u30d5\u30a9\u30eb\u30c8\u30c6\u30af\u30b9\u30c1\u30e3\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002")));
        this.setRandomTexture();
        this.soundPlayer = new SoundPlayableCompound((Entity)this, () -> this.multiModel.getTextureHolder(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).getTextureName());
        this.addDefaultModes(this);
    }

    public LittleMaidEntity(Level world) {
        this((EntityType<LittleMaidEntity>)((EntityType)Registration.LITTLE_MAID_MOB.get()), world);
    }

    public static AttributeSupplier.Builder createLittleMaidAttributes() {
        AttributeSupplier.Builder builder = TamableAnimal.m_21552_().m_22268_(Attributes.f_22279_, 0.3).m_22266_(Attributes.f_22281_).m_22266_(Attributes.f_22283_).m_22266_(Attributes.f_22286_).m_22268_(Attributes.f_22277_, 16.0);
        ReachAttributeUtil.addAttribute(builder);
        return builder;
    }

    public static boolean isValidNaturalSpawn(LevelAccessor world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_60838_((BlockGetter)world, pos) && world.m_45524_(pos, 0) > 8;
    }

    protected void m_8099_() {
        super.m_8099_();
        int priority = 0;
        Predicate<Goal> healthPredicate = g -> 0.5 < (double)Mth.m_14036_((float)(this.m_21223_() / this.m_21233_()), (float)0.0f, (float)1.0f);
        this.f_21345_.m_25352_(0, new TeleportTameOwnerGoal<LittleMaidEntity>(this, 16.0f));
        this.f_21345_.m_25352_(0, new StartPredicateGoalWrapper<Goal>(new TeleportTameOwnerGoal<LittleMaidEntity>(this, 6.0f), healthPredicate.negate()));
        this.f_21345_.m_25352_(++priority, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(++priority, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(++priority, new HealMyselfGoal<LittleMaidEntity>(this, 2, 1, stack -> stack.m_204117_(LMTags.Items.MAIDS_SALARY)));
        this.f_21345_.m_25352_(++priority, new WaitGoal<LittleMaidEntity>(this));
        this.f_21345_.m_25352_(++priority, new StartPredicateGoalWrapper<Goal>(new ModeWrapperGoal<LittleMaidEntity>(this), healthPredicate));
        this.f_21345_.m_25352_(++priority, new FollowTameOwnerGoal<LittleMaidEntity>(this, 1.5f, 8.0f, 6.0f));
        this.f_21345_.m_25352_(++priority, (Goal)new FollowAtHeldItemGoal((PathfinderMob)this, this, true, stack -> stack.m_204117_(LMTags.Items.MAIDS_SALARY)));
        this.f_21345_.m_25352_(++priority, (Goal)new LMStareAtHeldItemGoal(this, (Tameable)this, false, stack -> stack.m_204117_(LMTags.Items.MAIDS_EMPLOYABLE)));
        this.f_21345_.m_25352_(priority, (Goal)new LMStareAtHeldItemGoal(this, (Tameable)this, true, stack -> stack.m_204117_(LMTags.Items.MAIDS_SALARY)));
        this.f_21345_.m_25352_(++priority, new StartPredicateGoalWrapper<Goal>(new LMMoveToDropItemGoal(this, 8, 1.0), healthPredicate));
        this.f_21345_.m_25352_(++priority, new FollowTameOwnerGoal<LittleMaidEntity>(this, 1.0f, 6.0f, 4.0f));
        this.f_21345_.m_25352_(++priority, new FreedomGoal<LittleMaidEntity>(this, 0.8, 16.0));
        this.f_21345_.m_25352_(++priority, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(priority, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new PredicateRevengeGoal((PathfinderMob)this, entity -> !this.isFriend((LivingEntity)entity), new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(5, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 5, true, false, this::isEnemy));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MOVING_STATE, (Object)0);
        this.f_19804_.m_135372_(AIMING, (Object)false);
        this.f_19804_.m_135372_(BEGGING, (Object)false);
        this.f_19804_.m_135372_(MODE_NAME, (Object)"");
        this.f_19804_.m_135372_(BLOOD_SUCK, (Object)false);
    }

    public void addDefaultModes(LittleMaidEntity maid) {
        ModeManager.INSTANCE.getModes(maid).forEach(maid::addMode);
    }

    public void setRandomTexture() {
        LMTextureManager.INSTANCE.getAllTextures().stream().filter(h -> h.hasSkinTexture(false)).filter(h -> LMModelManager.INSTANCE.hasModel(h.getModelName())).min(Comparator.comparingInt(h -> ThreadLocalRandom.current().nextInt())).ifPresent(h -> Arrays.stream(TextureColors.values()).filter(c -> h.getTexture(c, false, false).isPresent()).min(Comparator.comparingInt(c -> ThreadLocalRandom.current().nextInt())).ifPresent(c -> {
            this.setColor((TextureColors)c);
            this.setTextureHolder((TextureHolder)h, IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD);
            if (h.hasArmorTexture()) {
                this.setTextureHolder((TextureHolder)h, IHasMultiModel.Layer.INNER, IHasMultiModel.Part.HEAD);
                this.setTextureHolder((TextureHolder)h, IHasMultiModel.Layer.INNER, IHasMultiModel.Part.BODY);
                this.setTextureHolder((TextureHolder)h, IHasMultiModel.Layer.INNER, IHasMultiModel.Part.LEGS);
                this.setTextureHolder((TextureHolder)h, IHasMultiModel.Layer.INNER, IHasMultiModel.Part.FEET);
                this.setTextureHolder((TextureHolder)h, IHasMultiModel.Layer.OUTER, IHasMultiModel.Part.HEAD);
                this.setTextureHolder((TextureHolder)h, IHasMultiModel.Layer.OUTER, IHasMultiModel.Part.BODY);
                this.setTextureHolder((TextureHolder)h, IHasMultiModel.Layer.OUTER, IHasMultiModel.Part.LEGS);
                this.setTextureHolder((TextureHolder)h, IHasMultiModel.Layer.OUTER, IHasMultiModel.Part.FEET);
            }
        }));
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        this.writeInventory(nbt);
        nbt.m_128405_("MovingState", this.getMovingState().getId());
        String old = nbt.m_128461_("MovingState");
        if (!old.isEmpty()) {
            this.setMovingState(Tameable.MovingState.fromName(old));
        }
        if (this.freedomPos != null) {
            nbt.m_128365_("FreedomPos", (Tag)NbtUtils.m_129224_((BlockPos)this.freedomPos));
        }
        this.writeContractable(nbt);
        this.writeModeData(nbt);
        nbt.m_128344_("SkinColor", (byte)this.getColor().getIndex());
        nbt.m_128379_("IsContract", this.isContract());
        nbt.m_128359_("SkinTexture", this.getTextureHolder(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).getTextureName());
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            nbt.m_128359_("ArmorTextureInner" + part.getPartName(), this.getTextureHolder(IHasMultiModel.Layer.INNER, part).getTextureName());
            nbt.m_128359_("ArmorTextureOuter" + part.getPartName(), this.getTextureHolder(IHasMultiModel.Layer.OUTER, part).getTextureName());
        }
        nbt.m_128359_("SoundConfigName", this.getConfigHolder().getName());
        this.writeIFF(nbt);
        this.setBloodSuck(nbt.m_128471_("isBloodSuck"));
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.readInventory(nbt);
        this.setMovingState(Tameable.MovingState.fromId(nbt.m_128451_("MovingState")));
        if (nbt.m_128441_("FreedomPos")) {
            this.freedomPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("FreedomPos"));
        }
        this.readContractable(nbt);
        this.readModeData(nbt);
        if (nbt.m_128441_("SkinColor")) {
            this.setColor(TextureColors.getColor((int)nbt.m_128445_("SkinColor")));
        }
        this.setContract(nbt.m_128471_("IsContract"));
        LMTextureManager textureManager = LMTextureManager.INSTANCE;
        if (nbt.m_128441_("SkinTexture")) {
            textureManager.getTexture(nbt.m_128461_("SkinTexture")).ifPresent(textureHolder -> this.setTextureHolder((TextureHolder)textureHolder, IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD));
        }
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            String inner = "ArmorTextureInner" + part.getPartName();
            String outer = "ArmorTextureOuter" + part.getPartName();
            if (nbt.m_128441_(inner)) {
                textureManager.getTexture(nbt.m_128461_(inner)).ifPresent(textureHolder -> this.setTextureHolder((TextureHolder)textureHolder, IHasMultiModel.Layer.INNER, part));
            }
            if (!nbt.m_128441_(outer)) continue;
            textureManager.getTexture(nbt.m_128461_(outer)).ifPresent(textureHolder -> this.setTextureHolder((TextureHolder)textureHolder, IHasMultiModel.Layer.OUTER, part));
        }
        if (nbt.m_128441_("SoundConfigName")) {
            LMConfigManager.INSTANCE.getConfig(nbt.m_128461_("SoundConfigName")).ifPresent(this::setConfigHolder);
        }
        this.readIFF(nbt);
        nbt.m_128379_("isBloodSuck", this.isBloodSuck());
    }

    public void writeCustomPacket(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.getColor());
        buf.writeBoolean(this.isContract());
        buf.m_130070_(this.getTextureHolder(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).getTextureName());
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            buf.m_130070_(this.getTextureHolder(IHasMultiModel.Layer.INNER, part).getTextureName());
            buf.m_130070_(this.getTextureHolder(IHasMultiModel.Layer.OUTER, part).getTextureName());
        }
        buf.m_130070_(this.getConfigHolder().getName());
    }

    public void readCustomPacket(FriendlyByteBuf buf) {
        this.setColor((TextureColors)buf.m_130066_(TextureColors.class));
        this.setContract(buf.readBoolean());
        LMTextureManager textureManager = LMTextureManager.INSTANCE;
        textureManager.getTexture(buf.m_130277_()).ifPresent(textureHolder -> this.setTextureHolder((TextureHolder)textureHolder, IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD));
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            textureManager.getTexture(buf.m_130277_()).ifPresent(textureHolder -> this.setTextureHolder((TextureHolder)textureHolder, IHasMultiModel.Layer.INNER, part));
            textureManager.getTexture(buf.m_130277_()).ifPresent(textureHolder -> this.setTextureHolder((TextureHolder)textureHolder, IHasMultiModel.Layer.OUTER, part));
        }
        LMConfigManager.INSTANCE.getConfig(buf.m_130277_()).ifPresent(this::setConfigHolder);
    }

    public void m_8119_() {
        super.m_8119_();
        this.fakePlayer.tick();
        this.m_21203_();
        this.itemContractable.tick();
        if (this.f_19853_.f_46443_) {
            this.tickInterestedAngle();
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        this.modeController.tick();
    }

    public boolean m_6785_(double distanceSquared) {
        return LMRBConfig.canDespawnLM() && !this.getTameOwnerUuid().isPresent();
    }

    public float m_5610_(BlockPos pos, LevelReader world) {
        return world.m_8055_(pos.m_7495_()).m_60838_((BlockGetter)world, pos) ? 10.0f : world.m_46863_(pos) - 0.5f;
    }

    protected float m_21519_(EquipmentSlot slot) {
        return 0.0f;
    }

    public boolean m_6779_(LivingEntity target) {
        return super.m_6779_(target) && !this.isFriend(target);
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return null;
    }

    public double m_6048_() {
        IMultiModel model = this.getModel(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).orElse(LMModelManager.INSTANCE.getDefaultModel());
        return model.getMountedYOffset(this.getCaps());
    }

    public double m_6049_() {
        IMultiModel model = this.getModel(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).orElse(LMModelManager.INSTANCE.getDefaultModel());
        return model.getyOffset(this.getCaps()) - this.m_20206_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        IMultiModel model = this.getModel(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).orElse(LMModelManager.INSTANCE.getDefaultModel());
        float height = model.getHeight(this.getCaps(), MMPose.convertPose((Pose)pose));
        float width = model.getWidth(this.getCaps(), MMPose.convertPose((Pose)pose));
        EntityDimensions dimensions = EntityDimensions.m_20395_((float)width, (float)height);
        return dimensions.m_20388_(this.m_6134_());
    }

    @Nullable
    public Entity m_5489_(ServerLevel destination) {
        Entity entity = super.m_5489_(destination);
        if (entity == null) {
            return null;
        }
        if (entity instanceof LittleMaidEntity) {
            ((LittleMaidEntity)entity).setFreedomPos(((LittleMaidEntity)entity).getFreedomPos());
        }
        return entity;
    }

    public boolean m_21444_(BlockPos pos) {
        if (pos.m_123314_((Vec3i)pos, 16.0) || this.getTameOwner().filter(owner -> owner.m_142538_().m_123314_((Vec3i)pos, 16.0)).isPresent()) {
            return super.m_21444_(pos);
        }
        return false;
    }

    public void m_8032_() {
        if (this.f_19853_.f_46443_ || this.f_20890_ || 0.2f < this.f_19796_.nextFloat()) {
            return;
        }
        if (this.m_21223_() / this.m_21233_() < 0.3f) {
            this.play("se_living_whine");
        } else if (this.f_19797_ % 4 == 0 && this.f_19853_.m_45527_(this.m_142538_())) {
            Biome biome = (Biome)this.f_19853_.m_204166_(this.m_142538_()).m_203334_();
            if (biome.m_198904_(this.m_142538_())) {
                this.play("se_living_cold");
            } else if (biome.m_198910_(this.m_142538_())) {
                this.play("se_living_hot");
            }
        } else if (this.f_19797_ % 4 == 1 && this.f_19853_.m_46471_()) {
            Biome biome = (Biome)this.f_19853_.m_204166_(this.m_142538_()).m_203334_();
            if (biome.m_47530_() == Biome.Precipitation.RAIN) {
                this.play("se_living_rain");
            } else if (biome.m_47530_() == Biome.Precipitation.SNOW) {
                this.play("se_living_snow");
            }
        } else if (this.m_21205_().m_41720_() == Items.f_42524_ || this.m_21206_().m_41720_() == Items.f_42524_) {
            int time = (int)(this.f_19853_.m_46468_() % 24000L);
            int min = 1200;
            if (1000 <= time && time < 1000 + min) {
                this.play("se_living_morning");
            } else if (13000 <= time || time < 1000) {
                this.play("se_living_night");
            } else {
                this.play("se_living_daytime");
            }
        } else {
            this.play("se_living_daytime");
        }
    }

    public void m_6667_(DamageSource source) {
        if (LMRBConfig.canResurrectionLM()) {
            this.m_146912_();
            this.f_20890_ = false;
            this.f_20919_ = 0;
            this.m_21153_(this.m_21233_());
            this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 1200, 5));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 1200, 5));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 1200, 5));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 1200, 5));
            return;
        }
        super.m_6667_(source);
        this.play("se_death");
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.f_20890_) {
            return super.m_6469_(source, amount);
        }
        if (!this.f_19853_.f_46443_ && amount <= 0.0f && source.m_7640_() instanceof Snowball) {
            this.play("se_hurt_snow");
            return false;
        }
        Entity attacker = source.m_7639_();
        if (attacker instanceof LivingEntity && this.isFriend((LivingEntity)attacker)) {
            return false;
        }
        boolean isHurtTime = 0 < this.f_20916_;
        boolean result = super.m_6469_(source, amount);
        if (!this.f_19853_.f_46443_ && !isHurtTime) {
            if (this.getTameOwnerUuid().isPresent() && this.getMovingState() == Tameable.MovingState.WAIT && result && 0.0f < amount) {
                this.setMovingState(Tameable.MovingState.ESCORT);
            }
            if (!result || amount <= 0.0f) {
                this.play("se_hurt_nodamege");
            } else if (amount > 0.0f && ((LivingAccessor)((Object)this)).blockedByShield_LM(source)) {
                this.play("se_hurt_guard");
            } else if (source == DamageSource.f_19315_) {
                this.play("se_hurt_fall");
            } else if (source.m_19384_()) {
                this.play("se_hurt_fire");
            } else {
                this.play("se_hurt");
            }
        }
        return result;
    }

    public void m_5837_(ServerLevel world, LivingEntity other) {
        if (this.isBloodSuck()) {
            this.play("se_laughter");
        }
        super.m_5837_(world, other);
    }

    protected Vec3 m_5763_(Vec3 movement, MoverType type) {
        if (type != MoverType.SELF && type != MoverType.PLAYER) {
            return movement;
        }
        if (this.isDamageSourceEmpty(this.m_142469_()) && !this.isDamageSourceEmpty(this.m_142469_().m_82386_(movement.f_82479_, 0.0, movement.f_82481_))) {
            movement = this.pushBack(movement, (x, z) -> !this.isDamageSourceEmpty(this.m_142469_().m_82386_(x.doubleValue(), 0.0, z.doubleValue())));
        }
        if (this.canClipAtLedge() && !this.isSafeFallHeight(this.m_20182_().m_82520_(movement.f_82479_, 0.0, movement.f_82481_))) {
            movement = this.pushBack(movement, (x, z) -> this.f_19853_.m_45756_((Entity)this, this.m_142469_().m_82386_(x.doubleValue(), (double)(-this.f_19793_), z.doubleValue())));
        }
        return movement;
    }

    private Vec3 pushBack(Vec3 movement, BiPredicate<Double, Double> biPredicate) {
        double dot = 0.05;
        double mX = movement.f_82479_;
        double mZ = movement.f_82481_;
        while (mX != 0.0 && biPredicate.test(mX, 0.0)) {
            if (mX < dot && mX >= -dot) {
                mX = 0.0;
                continue;
            }
            if (mX > 0.0) {
                mX -= dot;
                continue;
            }
            mX += dot;
        }
        while (mZ != 0.0 && biPredicate.test(0.0, mZ)) {
            if (mZ < dot && mZ >= -dot) {
                mZ = 0.0;
                continue;
            }
            if (mZ > 0.0) {
                mZ -= dot;
                continue;
            }
            mZ += dot;
        }
        while (mX != 0.0 && mZ != 0.0 && biPredicate.test(mX, mZ)) {
            double d = mX < dot && mX >= -dot ? 0.0 : (mX = mX > 0.0 ? (mX = mX - dot) : (mX = mX + dot));
            if (mZ < dot && mZ >= -dot) {
                mZ = 0.0;
                continue;
            }
            if (mZ > 0.0) {
                mZ -= dot;
                continue;
            }
            mZ += dot;
        }
        return new Vec3(mX, movement.f_82480_, mZ);
    }

    private boolean isDamageSourceEmpty(AABB box) {
        int minX = Mth.m_14107_((double)box.f_82288_);
        int maxX = Mth.m_14107_((double)box.f_82291_);
        int minY = Mth.m_14107_((double)box.f_82289_);
        int maxY = Mth.m_14107_((double)box.f_82292_);
        int minZ = Mth.m_14107_((double)box.f_82290_);
        int maxZ = Mth.m_14107_((double)box.f_82293_);
        for (int x = 0; x < maxX - minX + 1; ++x) {
            for (int y = 0; y < maxY - minY + 1; ++y) {
                for (int z = 0; z < maxZ - minZ + 1; ++z) {
                    BlockPathTypes pathNodeType = this.m_21573_().m_26575_().m_8086_((BlockGetter)this.f_19853_, minX + x, minY + y, minZ + z);
                    if (pathNodeType != BlockPathTypes.DAMAGE_FIRE && pathNodeType != BlockPathTypes.DAMAGE_CACTUS && pathNodeType != BlockPathTypes.DAMAGE_OTHER && pathNodeType != BlockPathTypes.LAVA) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isSafeFallHeight(Vec3 pos) {
        MobEffectInstance statusEffectInstance = this.m_21124_(MobEffects.f_19603_);
        BlockHitResult result = this.f_19853_.m_45547_(new ClipContext(pos, pos.m_82492_(0.0, (double)(4 + (statusEffectInstance == null ? 0 : statusEffectInstance.m_19564_() + 1)), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (result.m_6662_() == HitResult.Type.MISS) {
            return false;
        }
        Vec3 hitPos = result.m_82450_();
        if (0 < this.m_5639_((float)(pos.f_82480_ - hitPos.f_82480_ - 0.1), 1.0f)) {
            return false;
        }
        BlockPos checkPos = new BlockPos(pos.f_82479_, pos.f_82480_ - 1.0, pos.f_82481_);
        int i = 0;
        while ((double)i < pos.f_82480_ - hitPos.f_82480_ + 1.0) {
            BlockPathTypes pathNodeType = this.m_21573_().m_26575_().m_8086_((BlockGetter)this.f_19853_, checkPos.m_123341_(), checkPos.m_123342_(), checkPos.m_123343_());
            if (pathNodeType == BlockPathTypes.WALKABLE || pathNodeType == BlockPathTypes.BLOCKED) {
                return true;
            }
            if (pathNodeType == BlockPathTypes.DAMAGE_FIRE || pathNodeType == BlockPathTypes.DAMAGE_CACTUS || pathNodeType == BlockPathTypes.DAMAGE_OTHER || pathNodeType == BlockPathTypes.LAVA) {
                return false;
            }
            checkPos = checkPos.m_7495_();
            ++i;
        }
        return false;
    }

    private boolean canClipAtLedge() {
        return this.f_19861_ || this.f_19789_ < this.f_19793_ && !this.f_19853_.m_45756_((Entity)this, this.m_142469_().m_82386_(0.0, (double)(this.f_19789_ - this.f_19793_), 0.0));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_() || stack.m_41720_() instanceof IFFCopyBookItem) {
            return InteractionResult.PASS;
        }
        if (!this.hasTameOwner()) {
            if (stack.m_204117_(LMTags.Items.MAIDS_EMPLOYABLE)) {
                return this.contract(player, stack, false);
            }
            return InteractionResult.PASS;
        }
        if (!player.m_142081_().equals(this.m_142504_())) {
            return InteractionResult.PASS;
        }
        if (this.isStrike()) {
            if (stack.m_204117_(LMTags.Items.MAIDS_EMPLOYABLE)) {
                return this.contract(player, stack, true);
            }
            if (this.f_19853_ instanceof ServerLevel) {
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + (double)((0.5f - this.f_19796_.nextFloat()) * 0.2f), this.m_20188_() + (double)((0.5f - this.f_19796_.nextFloat()) * 0.2f), this.m_20189_() + (double)((0.5f - this.f_19796_.nextFloat()) * 0.2f), 5, 0.0, 1.0, 0.0, 0.1);
            }
            return InteractionResult.PASS;
        }
        if (stack.m_204117_(LMTags.Items.MAIDS_SALARY)) {
            return this.changeState(player, stack);
        }
        if (!player.f_19853_.f_46443_) {
            this.openContainer(player);
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    public InteractionResult changeState(Player player, ItemStack stack) {
        this.m_5496_(SoundEvents.f_12019_, 1.0f, this.f_19796_.nextFloat() * 0.1f + 1.0f);
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), 0.0, this.f_19796_.nextGaussian() * 0.02, 0.0);
        this.m_21573_().m_26573_();
        this.changeMovingState();
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                player.m_150109_().m_36057_(stack);
            }
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    public void changeMovingState() {
        Tameable.MovingState state = this.getMovingState();
        if (state == Tameable.MovingState.WAIT) {
            this.setMovingState(Tameable.MovingState.ESCORT);
        } else {
            this.setMovingState(Tameable.MovingState.WAIT);
        }
    }

    public InteractionResult contract(Player player, ItemStack stack, boolean isReContract) {
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), 0.0, this.f_19796_.nextGaussian() * 0.02, 0.0);
        if (!this.f_19853_.f_46443_) {
            if (isReContract) {
                this.play("se_Recontract");
            } else {
                this.play("se_getCake");
            }
        }
        this.setStrike(false);
        this.itemContractable.setUnpaidTimes(0);
        this.m_21573_().m_26573_();
        this.m_21816_(player.m_142081_());
        this.setMovingState(Tameable.MovingState.ESCORT);
        this.setContract(true);
        this.itemContractable.setContract(true);
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                player.m_150109_().m_36057_(stack);
            }
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    public void openContainer(Player player) {
        this.m_6703_(null);
        this.m_21573_().m_26573_();
        this.setModeName(this.getMode().map(Mode::getName).orElse(""));
        MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)this.screenFactory);
    }

    @Override
    public Container getInventory() {
        return this.littleMaidInventory.getInventory();
    }

    @Override
    public void writeInventory(CompoundTag tag) {
        this.littleMaidInventory.writeInventory(tag);
    }

    @Override
    public void readInventory(CompoundTag tag) {
        this.littleMaidInventory.readInventory(tag);
    }

    public Iterable<ItemStack> m_6167_() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.m_21205_(), this.m_21206_()});
    }

    public Iterable<ItemStack> m_6168_() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.m_6844_(EquipmentSlot.FEET), this.m_6844_(EquipmentSlot.LEGS), this.m_6844_(EquipmentSlot.CHEST), this.m_6844_(EquipmentSlot.HEAD)});
    }

    protected void m_6472_(DamageSource source, float amount) {
        ((Inventory)this.getInventory()).m_150072_(source, amount, Inventory.f_150068_);
    }

    protected void m_142642_(DamageSource source, float amount) {
        ((Inventory)this.getInventory()).m_150072_(source, amount, Inventory.f_150069_);
    }

    protected void m_7909_(float amount) {
        if (this.f_20935_.m_150930_(Items.f_42740_) && amount >= 3.0f) {
            int i = 1 + Mth.m_14143_((float)amount);
            InteractionHand hand = this.m_7655_();
            this.f_20935_.m_41622_(i, (LivingEntity)this, playerEntity -> playerEntity.m_21190_(hand));
            if (this.f_20935_.m_41619_()) {
                if (hand == InteractionHand.MAIN_HAND) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                } else {
                    this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                }
                this.f_20935_ = ItemStack.f_41583_;
                this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.f_19853_.f_46441_.nextFloat() * 0.4f);
            }
        }
    }

    public SlotAccess m_141942_(int mappedIndex) {
        if (mappedIndex >= 0 && mappedIndex < 36) {
            return SlotAccess.m_147292_((Container)this.getInventory(), (int)mappedIndex);
        }
        return super.m_141942_(mappedIndex);
    }

    public ItemStack m_6298_(ItemStack stack) {
        if (!(stack.m_41720_() instanceof ProjectileWeaponItem)) {
            return ItemStack.f_41583_;
        }
        Predicate predicate = ((ProjectileWeaponItem)stack.m_41720_()).m_6442_();
        ItemStack itemStack = ProjectileWeaponItem.m_43010_((LivingEntity)this, (Predicate)predicate);
        if (!itemStack.m_41619_()) {
            return itemStack;
        }
        predicate = ((ProjectileWeaponItem)stack.m_41720_()).m_6437_();
        for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
            ItemStack itemStack2 = this.getInventory().m_8020_(i);
            if (!predicate.test(itemStack2)) continue;
            return itemStack2;
        }
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        if (slot.m_20743_() == EquipmentSlot.Type.ARMOR) {
            Container inv = this.getInventory();
            inv.m_6836_(19 + slot.m_20749_(), stack);
            this.multiModel.updateArmor();
        } else if (slot == EquipmentSlot.MAINHAND) {
            this.getInventory().m_6836_(0, stack);
        } else if (slot == EquipmentSlot.OFFHAND) {
            this.getInventory().m_6836_(23, stack);
        }
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        if (slot.m_20743_() == EquipmentSlot.Type.ARMOR) {
            return this.getInventory().m_8020_(19 + slot.m_20749_());
        }
        if (slot == EquipmentSlot.MAINHAND) {
            return this.getInventory().m_8020_(0);
        }
        if (slot == EquipmentSlot.OFFHAND) {
            return this.getInventory().m_8020_(23);
        }
        return ItemStack.f_41583_;
    }

    protected void m_5907_() {
        Container inv = this.getInventory();
        if (inv instanceof Inventory) {
            ((LMInventorySupplier.LMInventory)inv).m_36071_();
        }
    }

    @Override
    public Optional<LivingEntity> getTameOwner() {
        return Optional.ofNullable(this.m_142480_());
    }

    @Override
    public void setTameOwnerUuid(UUID id) {
        this.m_21816_(id);
    }

    @Override
    public Optional<UUID> getTameOwnerUuid() {
        return Optional.ofNullable(this.m_142504_());
    }

    @Override
    public boolean hasTameOwner() {
        return this.getTameOwnerUuid().isPresent();
    }

    @Override
    public Tameable.MovingState getMovingState() {
        byte num = (Byte)this.f_19804_.m_135370_(MOVING_STATE);
        return Tameable.MovingState.fromId(num);
    }

    @Override
    public void setMovingState(Tameable.MovingState movingState) {
        int num = movingState.getId();
        this.f_19804_.m_135381_(MOVING_STATE, (Object)((byte)num));
    }

    @Override
    public void setFreedomPos(BlockPos freedomPos) {
        this.freedomPos = freedomPos;
    }

    @Override
    public BlockPos getFreedomPos() {
        if (this.freedomPos == null) {
            return this.m_142538_();
        }
        return this.freedomPos;
    }

    public void m_21837_(boolean inSittingPose) {
    }

    public boolean m_21825_() {
        return false;
    }

    public void m_21839_(boolean sitting) {
        this.setMovingState(sitting ? Tameable.MovingState.WAIT : Tameable.MovingState.ESCORT);
    }

    public boolean m_21827_() {
        return this.getMovingState() == Tameable.MovingState.WAIT;
    }

    public boolean m_21824_() {
        return this.hasTameOwner();
    }

    public boolean isBegging() {
        return (Boolean)this.f_19804_.m_135370_(BEGGING);
    }

    public void setBegging(boolean begging) {
        this.f_19804_.m_135381_(BEGGING, (Object)begging);
    }

    public boolean isBloodSuck() {
        return (Boolean)this.f_19804_.m_135370_(BLOOD_SUCK);
    }

    public void setBloodSuck(boolean isBloodSuck) {
        this.f_19804_.m_135381_(BLOOD_SUCK, (Object)isBloodSuck);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getInterestedAngle(float tickDelta) {
        return (this.prevInterestedAngle + (this.interestedAngle - this.prevInterestedAngle) * tickDelta) * ((this.m_142049_() % 2 == 0 ? 0.08f : -0.08f) * (float)Math.PI);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickInterestedAngle() {
        this.prevInterestedAngle = this.interestedAngle;
        this.interestedAngle = this.isBegging() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
    }

    @Override
    public boolean isStrike() {
        return this.itemContractable.isStrike();
    }

    @Override
    public void setStrike(boolean strike) {
        this.itemContractable.setStrike(strike);
    }

    @Override
    public void writeContractable(CompoundTag nbt) {
        this.itemContractable.writeContractable(nbt);
    }

    @Override
    public void readContractable(CompoundTag nbt) {
        this.itemContractable.readContractable(nbt);
    }

    public int getUnpaidDays() {
        return this.itemContractable.getUnpaidTimes();
    }

    @Override
    public Optional<Mode> getMode() {
        return this.modeController.getMode();
    }

    @Override
    public void writeModeData(CompoundTag tag) {
        this.modeController.writeModeData(tag);
    }

    @Override
    public void readModeData(CompoundTag tag) {
        this.modeController.readModeData(tag);
    }

    public void addMode(Mode mode) {
        this.modeController.addMode(mode);
    }

    public void setModeName(String modeName) {
        this.f_19804_.m_135381_(MODE_NAME, (Object)modeName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<String> getModeName() {
        String modeName = (String)this.f_19804_.m_135370_(MODE_NAME);
        if (modeName.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(modeName);
    }

    @Override
    public Optional<IFFTag> identify(LivingEntity target) {
        UUID ownerId = this.m_142504_();
        if (ownerId != null) {
            if (ownerId.equals(target.m_142081_())) {
                return Optional.of(IFFTag.FRIEND);
            }
            if (target instanceof Tameable && ownerId.equals(((Tameable)target).getTameOwnerUuid().orElse(null)) || target instanceof TamableAnimal && ownerId.equals(((TamableAnimal)target).m_142504_())) {
                return Optional.of(IFFTag.FRIEND);
            }
        }
        return this.getTameOwner().filter(owner -> owner instanceof HasIFF).map(owner -> (HasIFF)owner).flatMap(t -> t.identify(target));
    }

    @Override
    public void setIFFs(List<IFF> iffs) {
    }

    @Override
    public List<IFF> getIFFs() {
        return Lists.newArrayList();
    }

    @Override
    public void writeIFF(CompoundTag nbt) {
    }

    @Override
    public void readIFF(CompoundTag nbt) {
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        return !this.isFriend(target);
    }

    public boolean isFriend(LivingEntity entity) {
        return this.identify(entity).orElse(null) == IFFTag.FRIEND;
    }

    public boolean isEnemy(LivingEntity entity) {
        return this.isBloodSuck() ? !this.isFriend(entity) : this.identify(entity).orElse(null) == IFFTag.ENEMY;
    }

    @Override
    public boolean isAimingBow() {
        return (Boolean)this.f_19804_.m_135370_(AIMING);
    }

    @Override
    public void setAimingBow(boolean aiming) {
        this.f_19804_.m_135381_(AIMING, (Object)aiming);
    }

    @Override
    public FakePlayer getFakePlayer() {
        return this.fakePlayer.getFakePlayer();
    }

    public boolean isAllowChangeTexture(Entity entity, TextureHolder textureHolder, IHasMultiModel.Layer layer, IHasMultiModel.Part part) {
        return this.multiModel.isAllowChangeTexture(entity, textureHolder, layer, part);
    }

    public void setTextureHolder(TextureHolder textureHolder, IHasMultiModel.Layer layer, IHasMultiModel.Part part) {
        this.multiModel.setTextureHolder(textureHolder, layer, part);
        if (layer == IHasMultiModel.Layer.SKIN) {
            this.m_6210_();
        }
    }

    public TextureHolder getTextureHolder(IHasMultiModel.Layer layer, IHasMultiModel.Part part) {
        return this.multiModel.getTextureHolder(layer, part);
    }

    public void setColor(TextureColors textureColor) {
        this.multiModel.setColor(textureColor);
    }

    public TextureColors getColor() {
        return this.multiModel.getColor();
    }

    @Override
    public void setContract(boolean isContract) {
        this.multiModel.setContract(isContract);
        this.itemContractable.setContract(isContract);
    }

    @Override
    public boolean isContract() {
        return this.multiModel.isContract();
    }

    public Optional<IMultiModel> getModel(IHasMultiModel.Layer layer, IHasMultiModel.Part part) {
        return this.multiModel.getModel(layer, part);
    }

    public Optional<ResourceLocation> getTexture(IHasMultiModel.Layer layer, IHasMultiModel.Part part, boolean isLight) {
        return this.multiModel.getTexture(layer, part, isLight);
    }

    public IModelCaps getCaps() {
        return this.caps;
    }

    public boolean isArmorVisible(IHasMultiModel.Part part) {
        return this.multiModel.isArmorVisible(part);
    }

    public boolean isArmorGlint(IHasMultiModel.Part part) {
        return this.multiModel.isArmorGlint(part);
    }

    public void play(String soundName) {
        if (this.isBloodSuck()) {
            if (soundName.equals("se_findTarget_N")) {
                soundName = "se_findTarget_B";
            } else if (soundName.equals("se_attack")) {
                soundName = "se_attack_bloodsuck";
            }
        }
        this.soundPlayer.play(soundName);
    }

    public void setConfigHolder(ConfigHolder configHolder) {
        this.soundPlayer.setConfigHolder(configHolder);
    }

    public ConfigHolder getConfigHolder() {
        return this.soundPlayer.getConfigHolder();
    }

    public Packet<?> m_5654_() {
        return CustomMobSpawnPacket.createPacket((LivingEntity)this);
    }

    public static class LMStareAtHeldItemGoal
    extends TameableStareAtHeldItemGoal {
        private final LittleMaidEntity maid;

        public LMStareAtHeldItemGoal(LittleMaidEntity maid, Tameable tameable, boolean isTamed, Predicate<ItemStack> targetItem) {
            super((PathfinderMob)maid, tameable, isTamed, targetItem);
            this.maid = maid;
        }

        public void m_8056_() {
            super.m_8056_();
            this.maid.setBegging(true);
        }

        public void m_8041_() {
            super.m_8041_();
            this.maid.setBegging(false);
        }
    }

    public static class LMMoveToDropItemGoal
    extends MoveToDropItemGoal {
        protected final LittleMaidEntity maid;

        public LMMoveToDropItemGoal(LittleMaidEntity maid, int range, double speed) {
            super((PathfinderMob)maid, range, speed);
            this.maid = maid;
        }

        @Override
        public boolean m_8036_() {
            return this.maid.getMovingState() != Tameable.MovingState.WAIT && ((Inventory)this.maid.getInventory()).m_36062_() != -1 && super.m_8036_();
        }

        @Override
        public List<ItemEntity> findAroundDropItem() {
            return this.maid.getTameOwner().filter(owner -> this.maid.getMovingState() != Tameable.MovingState.WAIT).map(owner -> super.findAroundDropItem().stream().filter(item -> !this.isOwnerRange((Entity)item, (Entity)owner)).collect(Collectors.toList())).orElse(super.findAroundDropItem());
        }

        private boolean isOwnerRange(Entity entity, Entity owner) {
            Vec3 ownerPos = owner.m_20182_();
            Vec3 entityPos = entity.m_20182_().m_82546_(ownerPos);
            Vec3 ownerRot = owner.m_20252_(1.0f).m_82490_(4.0);
            double dot = entityPos.m_82526_(ownerRot);
            double range = 4.0;
            return 0.0 < dot && dot < 16.0;
        }
    }
}

