/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.sistr.littlemaidrebirth.entity.HasGuiEntitySupplier;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.setup.Registration;

public class LittleMaidScreenHandler
extends AbstractContainerMenu
implements HasGuiEntitySupplier<LittleMaidEntity> {
    private final Inventory playerInventory;
    private final Container maidInventory;
    private final LittleMaidEntity maid;
    private final int unpaidDays;

    public LittleMaidScreenHandler(int syncId, Inventory playerInventory, FriendlyByteBuf packet) {
        this(syncId, playerInventory, packet.m_130242_(), packet.readByte());
    }

    public LittleMaidScreenHandler(int syncId, Inventory playerInventory, int entityId, int unpaidDays) {
        super((MenuType)Registration.LITTLE_MAID_SCREEN_HANDLER.get(), syncId);
        LittleMaidEntity maid;
        this.playerInventory = playerInventory;
        this.unpaidDays = unpaidDays;
        this.maid = maid = (LittleMaidEntity)playerInventory.f_35978_.f_19853_.m_6815_(entityId);
        this.maidInventory = maid == null ? new SimpleContainer(24) : maid.getInventory();
        this.maidInventory.m_5856_(playerInventory.f_35978_);
        this.layoutMaidInventorySlots();
        this.layoutPlayerInventorySlots(8, 126);
    }

    @Override
    public LittleMaidEntity getGuiEntity() {
        return this.maid;
    }

    public int getUnpaidDays() {
        return this.unpaidDays;
    }

    public boolean m_6875_(Player player) {
        return this.maid != null && this.maid.m_6084_() && this.maid.m_20280_((Entity)player) < 64.0;
    }

    public ItemStack m_7648_(Player player, int invSlot) {
        ItemStack newStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(invSlot);
        if (slot == null || !slot.m_6657_()) {
            return newStack;
        }
        ItemStack originalStack = slot.m_7993_();
        newStack = originalStack.m_41777_();
        if (invSlot < 18 ? !this.m_38903_(originalStack, 24, 60, false) : (invSlot < 24 ? !this.m_38903_(originalStack, 0, 18, true) : !this.m_38903_(originalStack, 0, 18, false))) {
            return ItemStack.f_41583_;
        }
        if (originalStack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        return newStack;
    }

    private int addSlotRange(Container inventory, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_(new Slot(inventory, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(Container inventory, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(inventory, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox((Container)this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange((Container)this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    private void layoutMaidInventorySlots() {
        this.addSlotBox(this.maidInventory, 1, 8, 76, 9, 18, 2, 18);
        this.m_38897_(new Slot(this.maidInventory, 0, 116, 44));
        this.m_38897_(new Slot(this.maidInventory, 23, 152, 44));
        this.m_38897_(new Slot(this.maidInventory, 19 + EquipmentSlot.HEAD.m_20749_(), 8, 8){

            public boolean m_5857_(ItemStack stack) {
                return Mob.m_147233_((ItemStack)stack) == EquipmentSlot.HEAD;
            }
        });
        this.m_38897_(new Slot(this.maidInventory, 19 + EquipmentSlot.CHEST.m_20749_(), 8, 44){

            public boolean m_5857_(ItemStack stack) {
                return Mob.m_147233_((ItemStack)stack) == EquipmentSlot.CHEST;
            }
        });
        this.m_38897_(new Slot(this.maidInventory, 19 + EquipmentSlot.LEGS.m_20749_(), 80, 8){

            public boolean m_5857_(ItemStack stack) {
                return Mob.m_147233_((ItemStack)stack) == EquipmentSlot.LEGS;
            }
        });
        this.m_38897_(new Slot(this.maidInventory, 19 + EquipmentSlot.FEET.m_20749_(), 80, 44){

            public boolean m_5857_(ItemStack stack) {
                return Mob.m_147233_((ItemStack)stack) == EquipmentSlot.FEET;
            }
        });
    }
}

