/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.sistr.littlemaidrebirth.entity.Tameable;

public class FollowTameOwnerGoal<T extends PathfinderMob>
extends Goal {
    protected final T tameable;
    protected final float speed;
    protected final float followStartSq;
    protected final float followEndSq;
    private final PathNavigation navigation;
    private LivingEntity owner;
    private int updateCountdownTicks;
    private float oldWaterPathfindingPenalty;

    public FollowTameOwnerGoal(T tameable, float speed, float followStart, float followEnd) {
        this.tameable = tameable;
        this.speed = speed;
        this.followStartSq = followStart * followStart;
        this.followEndSq = followEnd * followEnd;
        this.navigation = tameable.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(tameable.m_21573_() instanceof GroundPathNavigation) && !(tameable.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean m_8036_() {
        LivingEntity tameOwner = ((Tameable)this.tameable).getTameOwner().orElse(null);
        if (tameOwner == null) {
            return false;
        }
        if (tameOwner.m_5833_()) {
            return false;
        }
        if (((Tameable)this.tameable).getMovingState() != Tameable.MovingState.ESCORT) {
            return false;
        }
        if (this.tameable.m_20280_((Entity)tameOwner) < (double)this.followStartSq) {
            return false;
        }
        this.owner = tameOwner;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_()) {
            return false;
        }
        if (((Tameable)this.tameable).getMovingState() != Tameable.MovingState.ESCORT) {
            return false;
        }
        return (double)this.followEndSq < this.tameable.m_20280_((Entity)this.owner);
    }

    public void m_8056_() {
        this.updateCountdownTicks = 0;
        this.oldWaterPathfindingPenalty = this.tameable.m_21439_(BlockPathTypes.WATER);
        this.tameable.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.tameable.m_21441_(BlockPathTypes.WATER, this.oldWaterPathfindingPenalty);
    }

    public void m_8037_() {
        this.tameable.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.tameable.m_8132_());
        if (--this.updateCountdownTicks > 0) {
            return;
        }
        this.updateCountdownTicks = 10;
        this.navigation.m_5624_((Entity)this.owner, (double)this.speed);
    }
}

