/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.goal;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.sistr.littlemaidmodelloader.entity.compound.SoundPlayable;
import net.sistr.littlemaidrebirth.entity.InventorySupplier;

public class HealMyselfGoal<T extends PathfinderMob>
extends Goal {
    private final T mob;
    private final int healInterval;
    private final int healAmount;
    private final Predicate<ItemStack> healItem;
    private int cool;
    private int cache;

    public HealMyselfGoal(T mob, int healInterval, int healAmount, Predicate<ItemStack> healItem) {
        this.mob = mob;
        this.healInterval = healInterval;
        this.healAmount = healAmount;
        this.healItem = healItem;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        assert (this.mob.m_21233_() != 0.0f);
        return (((PathfinderMob)this.mob).f_20916_ <= 0 && this.mob.m_21223_() <= this.mob.m_21233_() - 1.0f || this.mob.m_21223_() / this.mob.m_21233_() < 0.75f) && this.hasHealItem();
    }

    public boolean m_8045_() {
        return this.mob.m_21223_() < this.mob.m_21233_() && this.hasHealItem();
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21573_().m_26573_();
        this.cool = this.healInterval;
    }

    public void m_8037_() {
        if (0 < this.cool--) {
            return;
        }
        this.cool = this.healInterval;
        int slot = this.getHealItemSlot();
        ItemStack healItem = this.getHealItem(slot);
        if (healItem.m_41619_()) {
            return;
        }
        this.consumeHealItem(slot, healItem);
        this.mob.m_5634_((float)this.healAmount);
        this.mob.m_5496_(SoundEvents.f_12019_, 1.0f, this.mob.m_21187_().nextFloat() * 0.1f + 1.0f);
        this.mob.m_6674_(InteractionHand.MAIN_HAND);
        if (this.mob instanceof SoundPlayable) {
            if (this.mob.m_21223_() < this.mob.m_21233_()) {
                ((SoundPlayable)this.mob).play("se_eatSugar");
            } else {
                ((SoundPlayable)this.mob).play("se_eatSugar_MaxPower");
            }
        }
    }

    public boolean hasHealItem() {
        return this.getHealItemSlot() != -1;
    }

    public int getHealItemSlot() {
        Container inventory = ((InventorySupplier)this.mob).getInventory();
        if (this.cache != -1) {
            ItemStack slotStack = inventory.m_8020_(this.cache);
            if (this.healItem.test(slotStack)) {
                return this.cache;
            }
            this.cache = -1;
        }
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack slotStack = inventory.m_8020_(i);
            if (!this.healItem.test(slotStack)) continue;
            this.cache = i;
            return i;
        }
        return -1;
    }

    public ItemStack getHealItem(int slot) {
        if (slot == -1) {
            return ItemStack.f_41583_;
        }
        return ((InventorySupplier)this.mob).getInventory().m_8020_(slot);
    }

    public void consumeHealItem(int slot, ItemStack healItem) {
        healItem.m_41774_(1);
        if (healItem.m_41619_()) {
            ((InventorySupplier)this.mob).getInventory().m_8016_(slot);
        }
    }
}

