/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.sistr.littlemaidrebirth.entity.Tameable;

public class TeleportTameOwnerGoal<T extends PathfinderMob>
extends Goal {
    protected final T tameable;
    protected final Level world;
    protected final float teleportStartSq;
    private final PathNavigation navigation;
    private LivingEntity owner;
    private int updateCountdownTicks;

    public TeleportTameOwnerGoal(T tameable, float teleportStart) {
        this.tameable = tameable;
        this.world = ((PathfinderMob)tameable).f_19853_;
        this.teleportStartSq = teleportStart * teleportStart;
        this.navigation = tameable.m_21573_();
    }

    public boolean m_8036_() {
        LivingEntity tameOwner = ((Tameable)this.tameable).getTameOwner().orElse(null);
        if (tameOwner == null) {
            return false;
        }
        if (tameOwner.m_5833_()) {
            return false;
        }
        if (((Tameable)this.tameable).getMovingState() != Tameable.MovingState.ESCORT) {
            return false;
        }
        if (this.tameable.m_20280_((Entity)tameOwner) < (double)this.teleportStartSq) {
            return false;
        }
        this.owner = tameOwner;
        return true;
    }

    public boolean m_8045_() {
        if (((Tameable)this.tameable).getMovingState() != Tameable.MovingState.ESCORT) {
            return false;
        }
        return (double)this.teleportStartSq < this.tameable.m_20280_((Entity)this.owner);
    }

    public void m_8056_() {
        this.updateCountdownTicks = 0;
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
    }

    public void m_8037_() {
        this.tameable.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.tameable.m_8132_());
        if (--this.updateCountdownTicks > 0) {
            return;
        }
        this.updateCountdownTicks = 10;
        this.tryTeleport();
    }

    private void tryTeleport() {
        BlockPos ownerPos = this.owner.m_142538_();
        for (int i = 0; i < 10; ++i) {
            int x = this.getRandomInt(-3, 3);
            int y = this.getRandomInt(-1, 1);
            int z = this.getRandomInt(-3, 3);
            boolean bl = this.tryTeleportTo(ownerPos.m_123341_() + x, ownerPos.m_123342_() + y, ownerPos.m_123343_() + z);
            if (!bl) continue;
            return;
        }
    }

    private boolean tryTeleportTo(int x, int y, int z) {
        if (this.isOwnerRange((Entity)this.owner, x, y, z)) {
            return false;
        }
        if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.tameable.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, this.tameable.m_146908_(), this.tameable.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean isOwnerRange(Entity owner, int x, int y, int z) {
        Vec3 ownerPos = owner.m_20182_();
        Vec3 entityPos = new Vec3((double)x + 0.5, (double)y, (double)z + 0.5).m_82546_(ownerPos);
        Vec3 ownerRot = owner.m_20252_(1.0f).m_82490_(4.0);
        double dot = entityPos.m_82526_(ownerRot);
        double range = 4.0;
        return 0.0 < dot && dot < 16.0;
    }

    private boolean canTeleportTo(BlockPos pos) {
        BlockPathTypes pathNodeType = WalkNodeEvaluator.m_77604_((BlockGetter)this.world, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (pathNodeType != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockPos blockPos = pos.m_141950_((Vec3i)this.tameable.m_142538_());
        return this.world.m_45756_(this.tameable, this.tameable.m_142469_().m_82338_(blockPos));
    }

    private int getRandomInt(int min, int max) {
        return this.tameable.m_21187_().nextInt(max - min + 1) + min;
    }
}

