/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.iff;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.sistr.littlemaidrebirth.entity.iff.IFF;
import net.sistr.littlemaidrebirth.entity.iff.IFFType;

public class IFFTypeManager {
    private static final IFFTypeManager INSTANCE = new IFFTypeManager();
    private final BiMap<ResourceLocation, IFFType> iffTypes = HashBiMap.create();
    private boolean setup;

    public static IFFTypeManager getINSTANCE() {
        return INSTANCE;
    }

    public void register(ResourceLocation id, IFFType type) {
        this.iffTypes.put((Object)id, (Object)type);
    }

    private void setup(Level world) {
        this.setup = true;
        HashSet set = Sets.newHashSet((Iterable)this.iffTypes.values());
        for (IFFType type : set) {
            if (type.checkEntity(world)) continue;
            this.iffTypes.remove(this.iffTypes.inverse().get((Object)type));
        }
    }

    public Set<IFFType> getIFFTypes(Level world) {
        if (!this.setup) {
            this.setup(world);
        }
        return this.iffTypes.values();
    }

    public Optional<ResourceLocation> getId(IFFType iffType) {
        return Optional.ofNullable((ResourceLocation)this.iffTypes.inverse().get((Object)iffType));
    }

    public Optional<IFFType> getIFFType(ResourceLocation id) {
        return Optional.ofNullable((IFFType)this.iffTypes.get((Object)id));
    }

    public Optional<IFF> loadIFF(CompoundTag nbt) {
        return this.loadIFFType(nbt).map(IFFType::createIFF).map(iff -> iff.readTag(nbt));
    }

    public Optional<IFFType> loadIFFType(CompoundTag nbt) {
        ResourceLocation id = new ResourceLocation(nbt.m_128461_("IFFType"));
        return this.getIFFType(id);
    }
}

