/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.mode;

import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.sistr.littlemaidrebirth.api.mode.IRangedWeapon;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.api.mode.ModeType;
import net.sistr.littlemaidrebirth.entity.FakePlayer;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;

public class ArcherMode
extends Mode {
    private final LittleMaidEntity mob;
    private final float inaccuracy;
    private final Predicate<Entity> friend;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private int reUseCool;

    public ArcherMode(ModeType<? extends ArcherMode> modeType, String name, LittleMaidEntity mob, float inaccuracy, Predicate<Entity> friend) {
        super(modeType, name);
        this.mob = mob;
        this.inaccuracy = inaccuracy;
        this.friend = friend;
    }

    @Override
    public boolean shouldExecute() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
    }

    @Override
    public boolean shouldContinueExecuting() {
        return this.shouldExecute();
    }

    @Override
    public void startExecuting() {
        this.mob.m_21561_(true);
        this.mob.setAimingBow(true);
        this.mob.play("se_findTarget_N");
    }

    @Override
    public void tick() {
        int interval;
        float yaw;
        boolean prevCanSee;
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return;
        }
        double distanceSq = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        boolean canSee = this.mob.m_21574_().m_148306_((Entity)target);
        ItemStack itemStack = this.mob.m_21205_();
        Item item = itemStack.m_41720_();
        float maxRange = item instanceof IRangedWeapon ? ((IRangedWeapon)item).getMaxRange_LMRB(itemStack, (LivingEntity)this.mob) : 16.0f;
        Vec3 start = this.mob.m_20299_(1.0f);
        Vec3 end = start.m_82549_(this.mob.m_20252_(1.0f).m_82490_((double)maxRange));
        AABB box = new AABB(start, end).m_82400_(1.0);
        EntityHitResult clear = ProjectileUtil.m_37304_((Level)this.mob.f_19853_, (Entity)this.mob, (Vec3)start, (Vec3)end, (AABB)box, this.friend);
        canSee = canSee && clear == null;
        boolean bl = prevCanSee = 0 < this.seeTime;
        if (canSee != prevCanSee) {
            this.seeTime = 0;
        }
        if (prevCanSee && !canSee) {
            boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
        }
        this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
        if (distanceSq < (double)(maxRange * maxRange)) {
            this.mob.m_21573_().m_26573_();
            ++this.strafingTime;
        } else {
            this.strafingTime = -1;
        }
        if (20 <= this.strafingTime) {
            if ((double)this.mob.m_21187_().nextFloat() < 0.1) {
                this.strafingClockwise = !this.strafingClockwise;
            }
            this.strafingTime = 0;
        }
        if ((double)maxRange < distanceSq) {
            this.strafingBackwards = false;
        } else if (distanceSq < (double)(maxRange * 0.75f)) {
            this.strafingBackwards = true;
        }
        this.mob.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
        this.mob.m_21391_((Entity)target, 30.0f, 30.0f);
        FakePlayer fakePlayer = this.mob.getFakePlayer();
        Vec3 vec3d = fakePlayer.m_20299_(1.0f);
        Vec3 targetPos = target.m_20299_(1.0f);
        double xD = targetPos.f_82479_ - vec3d.f_82479_;
        double yD = targetPos.f_82480_ - vec3d.f_82480_;
        double zD = targetPos.f_82481_ - vec3d.f_82481_;
        double hDist = Mth.m_14116_((float)((float)(xD * xD + zD * zD)));
        float pitch = (float)(-(Mth.m_14136_((double)yD, (double)hDist) * 57.29577951308232));
        pitch += (this.mob.m_21187_().nextFloat() * 2.0f - 1.0f) * (this.mob.m_21187_().nextFloat() * 2.0f - 1.0f) * this.inaccuracy;
        pitch = Mth.m_14177_((float)pitch);
        fakePlayer.f_20885_ = yaw = Mth.m_14177_((float)((float)(Mth.m_14136_((double)zD, (double)xD) * 57.29577951308232) - 90.0f));
        fakePlayer.m_146922_(yaw);
        fakePlayer.m_146926_(pitch);
        if (--this.reUseCool < 0 && !fakePlayer.m_6117_()) {
            this.reUseCool = 4;
            if (-60 <= this.seeTime) {
                this.mob.setAimingBow(true);
                this.mob.play("se_sighting");
                ItemStack stack = fakePlayer.m_21205_();
                stack.m_41682_(this.mob.f_19853_, (Player)fakePlayer, InteractionHand.MAIN_HAND);
            }
            return;
        }
        if (!canSee) {
            if (this.seeTime < -60) {
                this.mob.setAimingBow(false);
                fakePlayer.m_5810_();
            }
            return;
        }
        int useCount = fakePlayer.m_21252_();
        int n = interval = item instanceof IRangedWeapon ? ((IRangedWeapon)item).getInterval_LMRB(itemStack, (LivingEntity)this.mob) : 25;
        if (interval <= useCount) {
            Entity entity2;
            float distance = Mth.m_14116_((float)((float)distanceSq));
            EntityHitResult result = ProjectileUtil.m_37304_((Level)this.mob.f_19853_, (Entity)this.mob, (Vec3)this.mob.m_20299_(1.0f), (Vec3)target.m_20299_(1.0f), (AABB)this.mob.m_142469_().m_82400_((double)distance), entity -> !entity.m_5833_() && entity.m_6084_() && entity.m_5829_());
            if (result != null && result.m_6662_() == HitResult.Type.ENTITY && (entity2 = result.m_82443_()) != target) {
                return;
            }
            fakePlayer.m_21253_();
            this.mob.play("se_shoot");
        }
    }

    @Override
    public void resetTask() {
        this.mob.m_21561_(false);
        this.seeTime = 0;
        this.mob.setAimingBow(false);
        this.mob.m_21573_().m_26573_();
        FakePlayer fakePlayer = this.mob.getFakePlayer();
        fakePlayer.m_5810_();
    }
}

