/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.mode;

import java.util.Arrays;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.api.mode.ModeType;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.util.AbstractFurnaceAccessor;
import net.sistr.littlemaidrebirth.util.BlockFinder;

public class CookingMode
extends Mode {
    private final LittleMaidEntity mob;
    private final int inventoryStart;
    private final int inventoryEnd;
    private BlockPos furnacePos;
    private int timeToRecalcPath;
    private int findCool;

    public CookingMode(ModeType<? extends CookingMode> modeType, String name, LittleMaidEntity mob, int inventoryStart, int inventoryEnd) {
        super(modeType, name);
        this.mob = mob;
        this.inventoryStart = inventoryStart;
        this.inventoryEnd = inventoryEnd;
    }

    @Override
    public void startModeTask() {
    }

    @Override
    public boolean shouldExecute() {
        if (0 < --this.findCool) {
            return false;
        }
        this.findCool = 60;
        if (this.getFuel().isEmpty()) {
            return false;
        }
        if (this.furnacePos != null && this.getFurnaceBlockEntity(this.furnacePos).isPresent()) {
            return true;
        }
        this.furnacePos = null;
        Optional<BlockPos> optional = this.findFurnacePos();
        if (optional.isEmpty()) {
            return false;
        }
        this.furnacePos = optional.get();
        return true;
    }

    public OptionalInt getFuel() {
        Container inventory = this.mob.getInventory();
        for (int i = this.inventoryStart; i < this.inventoryEnd; ++i) {
            ItemStack itemstack = inventory.m_8020_(i);
            if (!this.isFuel(itemstack)) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public boolean isFuel(ItemStack stack) {
        return AbstractFurnaceBlockEntity.m_58399_((ItemStack)stack);
    }

    public Optional<BlockPos> findFurnacePos() {
        return BlockFinder.searchTargetBlock(this.mob.m_142538_(), this::canUseFurnace, this::canSeeThrough, Arrays.asList(Direction.values()), 1000).filter(pos -> pos.m_123333_((Vec3i)this.mob.m_142538_()) < 8);
    }

    public boolean canUseFurnace(BlockPos pos) {
        return this.getFurnaceBlockEntity(pos).filter(this::canUseFurnace).isPresent();
    }

    public Optional<AbstractFurnaceBlockEntity> getFurnaceBlockEntity(BlockPos pos) {
        if (pos == null) {
            return Optional.empty();
        }
        BlockEntity tile = this.mob.f_19853_.m_7702_(pos);
        if (tile instanceof AbstractFurnaceBlockEntity) {
            return Optional.of((AbstractFurnaceBlockEntity)tile);
        }
        return Optional.empty();
    }

    public boolean canUseFurnace(AbstractFurnaceBlockEntity tile) {
        for (int slot : tile.m_7071_(Direction.UP)) {
            RecipeType<? extends AbstractCookingRecipe> recipeType;
            ItemStack stack = tile.m_8020_(slot);
            if (!stack.m_41619_() || !this.getAllCoockable(recipeType = ((AbstractFurnaceAccessor)tile).getRecipeType_LM()).anyMatch(cookable -> tile.m_7155_(slot, cookable, Direction.UP))) continue;
            return true;
        }
        return false;
    }

    public Stream<ItemStack> getAllCoockable(RecipeType<? extends AbstractCookingRecipe> recipeType) {
        Container inventory = this.mob.getInventory();
        Stream.Builder<ItemStack> builder = Stream.builder();
        for (int i = this.inventoryStart; i < this.inventoryEnd; ++i) {
            ItemStack slotStack = inventory.m_8020_(i);
            if (!this.getRecipe(slotStack, recipeType).isPresent()) continue;
            builder.accept(slotStack);
        }
        return builder.build();
    }

    public Optional<? extends AbstractCookingRecipe> getRecipe(ItemStack stack, RecipeType<? extends AbstractCookingRecipe> recipeType) {
        return this.mob.f_19853_.m_7465_().m_44015_(recipeType, (Container)new SimpleContainer(new ItemStack[]{stack}), this.mob.f_19853_);
    }

    public boolean canSeeThrough(BlockPos pos) {
        return true;
    }

    @Override
    public void startExecuting() {
        this.findCool = 0;
    }

    @Override
    public boolean shouldContinueExecuting() {
        if (this.furnacePos == null) {
            return false;
        }
        AbstractFurnaceBlockEntity furnace = this.getFurnaceBlockEntity(this.furnacePos).orElse(null);
        if (furnace == null) {
            return false;
        }
        for (int availableSlot : furnace.m_7071_(Direction.DOWN)) {
            ItemStack result = furnace.m_8020_(availableSlot);
            if (result.m_41619_() || !furnace.m_7157_(availableSlot, result, Direction.DOWN)) continue;
            return true;
        }
        if (((AbstractFurnaceAccessor)furnace).isBurningFire_LM()) {
            for (int availableSlot : furnace.m_7071_(Direction.UP)) {
                if (furnace.m_8020_(availableSlot).m_41619_()) continue;
                return true;
            }
        }
        return this.getFuel().isPresent() && this.getAllCoockable(((AbstractFurnaceAccessor)furnace).getRecipeType_LM()).findAny().isPresent();
    }

    @Override
    public void tick() {
        AbstractFurnaceBlockEntity furnace = this.getFurnaceBlockEntity(this.furnacePos).orElse(null);
        if (furnace == null) {
            this.furnacePos = null;
            return;
        }
        this.mob.m_21563_().m_24946_((double)this.furnacePos.m_123341_() + 0.5, (double)this.furnacePos.m_123342_() + 0.5, (double)this.furnacePos.m_123343_() + 0.5);
        if (!this.mob.m_142538_().m_123314_((Vec3i)this.furnacePos, 2.0)) {
            if (this.mob.m_6144_()) {
                this.mob.m_20260_(false);
            }
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                this.mob.m_21573_().m_26519_((double)this.furnacePos.m_123341_() + 0.5, (double)this.furnacePos.m_123342_() + 0.5, (double)this.furnacePos.m_123343_() + 0.5, 1.0);
            }
            return;
        }
        this.mob.m_21573_().m_26573_();
        if (!this.mob.m_6144_()) {
            this.mob.m_20260_(true);
        }
        Container inventory = this.mob.getInventory();
        RecipeType<? extends AbstractCookingRecipe> recipeType = ((AbstractFurnaceAccessor)furnace).getRecipeType_LM();
        this.getCookable(recipeType).ifPresent(cookableIndex -> this.tryInsertCookable(furnace, inventory, cookableIndex));
        this.getFuel().ifPresent(fuelIndex -> this.tryInsertFuel(furnace, inventory, fuelIndex));
        this.tryExtractItem(furnace, inventory);
    }

    public OptionalInt getCookable(RecipeType<? extends AbstractCookingRecipe> recipeType) {
        Container inventory = this.mob.getInventory();
        for (int i = this.inventoryStart; i < this.inventoryEnd; ++i) {
            ItemStack slotStack = inventory.m_8020_(i);
            if (!this.getRecipe(slotStack, recipeType).isPresent()) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    private void tryInsertCookable(AbstractFurnaceBlockEntity furnace, Container inventory, int cookableIndex) {
        int[] materialSlots;
        for (int materialSlot : materialSlots = furnace.m_7071_(Direction.UP)) {
            ItemStack material;
            ItemStack materialSlotStack = furnace.m_8020_(materialSlot);
            if (!materialSlotStack.m_41619_() || !furnace.m_7155_(materialSlot, material = inventory.m_8020_(cookableIndex), Direction.UP)) continue;
            furnace.m_6836_(materialSlot, material);
            inventory.m_8016_(cookableIndex);
            furnace.m_6596_();
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            this.mob.m_5496_(SoundEvents.f_12019_, 1.0f, this.mob.m_21187_().nextFloat() * 0.1f + 1.0f);
            this.mob.play("se_cookingStart");
            break;
        }
    }

    private void tryInsertFuel(AbstractFurnaceBlockEntity furnace, Container inventory, int fuelIndex) {
        int[] fuelSlots;
        for (int fuelSlot : fuelSlots = furnace.m_7071_(Direction.NORTH)) {
            ItemStack fuel;
            ItemStack fuelSlotStack = furnace.m_8020_(fuelSlot);
            if (!fuelSlotStack.m_41619_() || !furnace.m_7155_(fuelSlot, fuel = inventory.m_8020_(fuelIndex), Direction.NORTH)) continue;
            furnace.m_6836_(fuelSlot, fuel);
            inventory.m_8016_(fuelIndex);
            furnace.m_6596_();
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            this.mob.m_5496_(SoundEvents.f_12019_, 1.0f, this.mob.m_21187_().nextFloat() * 0.1f + 1.0f);
            this.mob.play("se_addFuel");
            break;
        }
    }

    private void tryExtractItem(AbstractFurnaceBlockEntity furnace, Container inventory) {
        int[] resultSlots;
        for (int resultSlot : resultSlots = furnace.m_7071_(Direction.DOWN)) {
            ItemStack resultStack = furnace.m_8020_(resultSlot);
            if (resultStack.m_41619_() || !furnace.m_7157_(resultSlot, resultStack, Direction.DOWN)) continue;
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            this.mob.m_5496_(SoundEvents.f_12019_, 1.0f, this.mob.m_21187_().nextFloat() * 0.1f + 1.0f);
            this.mob.play("se_cookingOver");
            ItemStack copy = resultStack.m_41777_();
            ItemStack leftover = HopperBlockEntity.m_59326_((Container)furnace, (Container)inventory, (ItemStack)furnace.m_7407_(resultSlot, 1), null);
            if (leftover.m_41619_()) {
                furnace.m_6596_();
                continue;
            }
            furnace.m_6836_(resultSlot, copy);
        }
    }

    @Override
    public void resetTask() {
        this.mob.m_20260_(false);
    }

    @Override
    public void endModeTask() {
    }

    @Override
    public void writeModeData(CompoundTag nbt) {
        if (this.furnacePos != null) {
            nbt.m_128365_("FurnacePos", (Tag)NbtUtils.m_129224_((BlockPos)this.furnacePos));
        }
    }

    @Override
    public void readModeData(CompoundTag nbt) {
        if (nbt.m_128441_("FurnacePos")) {
            this.furnacePos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("FurnacePos"));
        }
    }
}

