/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.mode;

import java.util.OptionalInt;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.sistr.littlemaidmodelloader.entity.compound.SoundPlayable;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.api.mode.ModeType;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;

public class HealerMode
extends Mode {
    protected final LittleMaidEntity mob;
    protected final int inventoryStart;
    protected final int inventoryEnd;

    public HealerMode(ModeType<? extends Mode> modeType, String name, LittleMaidEntity mob, int inventoryStart, int inventoryEnd) {
        super(modeType, name);
        this.mob = mob;
        this.inventoryStart = inventoryStart;
        this.inventoryEnd = inventoryEnd;
    }

    @Override
    public boolean shouldExecute() {
        LivingEntity owner = this.mob.getTameOwner().orElse(null);
        if (!(owner instanceof Player)) {
            return false;
        }
        if (!((Player)owner).m_36324_().m_38721_()) {
            return false;
        }
        return this.getFoodsIndex().isPresent();
    }

    public OptionalInt getFoodsIndex() {
        Container inventory = this.mob.getInventory();
        for (int i = this.inventoryStart; i < this.inventoryEnd; ++i) {
            ItemStack itemstack = inventory.m_8020_(i);
            if (!this.isFoods(itemstack)) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public boolean isFoods(ItemStack stack) {
        return stack.m_41720_().m_41472_();
    }

    @Override
    public boolean shouldContinueExecuting() {
        return this.shouldExecute();
    }

    @Override
    public void tick() {
        this.getFoodsIndex().ifPresent(index -> {
            Container inventory = this.mob.getInventory();
            ItemStack stack = inventory.m_8020_(index);
            this.mob.getTameOwner().ifPresent(owner -> {
                owner.m_5584_(owner.f_19853_, stack);
                inventory.m_7407_(index, 0);
                if (owner instanceof SoundPlayable) {
                    ((SoundPlayable)owner).play("se_healing");
                }
            });
        });
    }
}

