/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.mode;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.entity.InventorySupplier;
import net.sistr.littlemaidrebirth.entity.mode.ModeSupplier;

public class ModeController
implements ModeSupplier {
    private final LivingEntity owner;
    private final InventorySupplier hasInventory;
    private final Set<Mode> modes = Sets.newHashSet();
    private Mode nowMode;
    private Item prevItem = Items.f_41852_;
    private CompoundTag tempModeData;

    public ModeController(LivingEntity owner, InventorySupplier hasInventory, Set<Mode> modes) {
        this.owner = owner;
        this.hasInventory = hasInventory;
        this.modes.addAll(modes);
    }

    public void addMode(Mode mode) {
        this.modes.add(mode);
    }

    @Override
    public Optional<Mode> getMode() {
        return Optional.ofNullable(this.nowMode);
    }

    @Override
    public void writeModeData(CompoundTag nbt) {
        this.getMode().ifPresent(mode -> {
            CompoundTag modeData = new CompoundTag();
            mode.writeModeData(modeData);
            nbt.m_128365_("ModeData", (Tag)modeData);
        });
    }

    @Override
    public void readModeData(CompoundTag nbt) {
        if (nbt.m_128441_("ModeData")) {
            this.tempModeData = nbt.m_128469_("ModeData");
        }
    }

    public void tick() {
        if (!this.isModeContinue()) {
            if (this.hasModeItem()) {
                return;
            }
            this.changeMode();
        }
        this.prevItem = this.owner.m_21205_().m_41720_();
    }

    public boolean hasModeItem() {
        if (this.nowMode != null && this.owner.m_21205_().m_41619_()) {
            Container inventory = this.hasInventory.getInventory();
            for (int index = 0; index < inventory.m_6643_(); ++index) {
                ItemStack stack = inventory.m_8020_(index);
                if (!this.nowMode.getModeType().isModeItem(stack)) continue;
                this.owner.m_21008_(InteractionHand.MAIN_HAND, stack.m_41777_());
                inventory.m_8016_(index);
                this.prevItem = this.owner.m_21205_().m_41720_();
                return true;
            }
        }
        return false;
    }

    public boolean isModeContinue() {
        return this.prevItem == this.owner.m_21205_().m_41720_();
    }

    public void changeMode() {
        Mode newMode = this.getNewMode();
        if (this.nowMode != newMode) {
            if (this.nowMode != null) {
                this.nowMode.resetTask();
                this.nowMode.endModeTask();
            }
            if (newMode != null) {
                if (this.tempModeData != null) {
                    newMode.readModeData(this.tempModeData);
                    this.tempModeData = null;
                }
                newMode.startModeTask();
            }
            this.nowMode = newMode;
        }
    }

    public Mode getNewMode() {
        for (Mode mode : this.modes) {
            if (!mode.getModeType().isModeItem(this.owner.m_21205_())) continue;
            return mode;
        }
        return null;
    }
}

