/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.mode;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.api.mode.ModeType;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;

public class RipperMode
extends Mode {
    protected final LittleMaidEntity mob;
    protected final float radius;
    protected final List<Entity> shearable = Lists.newArrayList();
    protected int timeToRecalcPath;
    protected int timeToIgnore;

    public RipperMode(ModeType<? extends Mode> modeType, String name, LittleMaidEntity mob, float radius) {
        super(modeType, name);
        this.mob = mob;
        this.radius = radius;
    }

    @Override
    public boolean shouldExecute() {
        this.shearable.addAll(this.findCanShearableMob());
        return !this.shearable.isEmpty();
    }

    public Collection<Entity> findCanShearableMob() {
        AABB bb = new AABB(this.mob.m_20185_() + (double)this.radius, this.mob.m_20186_() + (double)(this.radius / 4.0f), this.mob.m_20189_() + (double)this.radius, this.mob.m_20185_() - (double)this.radius, this.mob.m_20186_() - (double)(this.radius / 4.0f), this.mob.m_20189_() - (double)this.radius);
        return this.mob.f_19853_.m_6249_((Entity)this.mob, bb, entity -> entity instanceof LivingEntity && entity instanceof Shearable && ((Shearable)entity).m_6220_() && this.mob.m_21574_().m_148306_(entity));
    }

    @Override
    public boolean shouldContinueExecuting() {
        return !this.shearable.isEmpty();
    }

    @Override
    public void startExecuting() {
        this.mob.m_21573_().m_26573_();
        List tempList = this.shearable.stream().sorted(Comparator.comparingDouble(entity -> entity.m_20280_((Entity)this.mob))).collect(Collectors.toList());
        this.shearable.clear();
        this.shearable.addAll(tempList);
    }

    @Override
    public void tick() {
        Entity target = this.shearable.get(0);
        if (!(target instanceof LivingEntity) || !(target instanceof Shearable)) {
            this.shearable.remove(0);
            this.timeToIgnore = 0;
            return;
        }
        if (200 < ++this.timeToIgnore) {
            this.shearable.remove(0);
            this.timeToIgnore = 0;
            return;
        }
        if (target.m_20280_((Entity)this.mob) < 4.0) {
            ItemStack stack = this.mob.m_21205_();
            if (((Shearable)target).m_6220_()) {
                ((Shearable)target).m_5851_(SoundSource.PLAYERS);
                stack.m_41622_(1, (LivingEntity)target, e -> e.m_21190_(InteractionHand.MAIN_HAND));
            }
            this.shearable.remove(0);
            this.timeToIgnore = 0;
            return;
        }
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            this.mob.m_21573_().m_26519_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0);
        }
    }

    @Override
    public void resetTask() {
        this.timeToIgnore = 0;
        this.timeToRecalcPath = 0;
        this.shearable.clear();
    }
}

