/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.mode;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.api.mode.ModeType;
import net.sistr.littlemaidrebirth.entity.FakePlayer;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.Tameable;
import net.sistr.littlemaidrebirth.util.BlockFinder;

public class TorcherMode
extends Mode {
    protected final LittleMaidEntity mob;
    protected final float distance;
    protected BlockPos placePos;
    protected int timeToRecalcPath;
    protected int timeToIgnore;
    protected int cool;

    public TorcherMode(ModeType<? extends Mode> modeType, String name, LittleMaidEntity mob, float distance) {
        super(modeType, name);
        this.mob = mob;
        this.distance = distance;
    }

    @Override
    public boolean shouldExecute() {
        BlockPos base;
        if (0 < --this.cool) {
            return false;
        }
        this.cool = 20;
        if (this.mob.getMovingState() == Tameable.MovingState.ESCORT) {
            Entity owner = this.mob.getTameOwner().orElse(null);
            if (owner == null) {
                return false;
            }
            base = owner.m_142538_();
        } else {
            base = this.mob.m_142538_();
        }
        this.placePos = this.findSpawnablePoint(base).orElse(null);
        return this.placePos != null;
    }

    public Optional<BlockPos> findSpawnablePoint(BlockPos base) {
        return BlockFinder.searchTargetBlock(base, pos -> this.isSpawnable((BlockPos)pos) && this.isReachable((BlockPos)pos), pos -> true, Arrays.asList(Direction.values()), 4000);
    }

    public boolean isSpawnable(BlockPos pos) {
        BlockPos posUp = pos.m_7494_();
        return this.mob.f_19853_.m_8055_(pos).m_60838_((BlockGetter)this.mob.f_19853_, pos) && this.mob.f_19853_.m_46859_(posUp) && this.mob.f_19853_.m_46803_(posUp) <= 8;
    }

    public boolean isReachable(BlockPos pos) {
        Path path = this.mob.m_21573_().m_7864_(pos, 4);
        return path != null && path.m_77403_();
    }

    @Override
    public boolean shouldContinueExecuting() {
        return this.placePos != null;
    }

    @Override
    public void startExecuting() {
        this.mob.m_21573_().m_26573_();
        Path path = this.mob.m_21573_().m_26524_((double)this.placePos.m_123341_(), (double)this.placePos.m_123342_(), (double)this.placePos.m_123343_(), 3);
        this.mob.m_21573_().m_26536_(path, 1.0);
        this.mob.play("se_findTarget_D");
    }

    @Override
    public void tick() {
        if (100 < ++this.timeToIgnore || 8 < this.mob.f_19853_.m_46803_(this.placePos.m_7494_())) {
            this.placePos = null;
            this.timeToIgnore = 0;
            return;
        }
        if (this.distance * 2.0f < (float)this.placePos.m_123333_((Vec3i)this.mob.m_142538_())) {
            this.placePos = null;
            return;
        }
        Item item = this.mob.m_21205_().m_41720_();
        if (!(item instanceof BlockItem)) {
            return;
        }
        if (9.0 < this.mob.m_20275_(this.placePos.m_123341_(), this.placePos.m_123342_(), this.placePos.m_123343_())) {
            if (--this.timeToRecalcPath < 0) {
                this.timeToRecalcPath = 20;
                Path path = this.mob.m_21573_().m_26524_((double)this.placePos.m_123341_(), (double)this.placePos.m_123342_(), (double)this.placePos.m_123343_(), 3);
                this.mob.m_21573_().m_26536_(path, 1.0);
            }
            return;
        }
        Vec3 start = this.mob.m_20299_(1.0f);
        Vec3 end = new Vec3((double)this.placePos.m_123341_() + 0.5, (double)this.placePos.m_123342_() + 1.0, (double)this.placePos.m_123343_() + 0.5);
        BlockHitResult result = this.mob.f_19853_.m_45547_(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.mob));
        FakePlayer fakePlayer = this.mob.getFakePlayer();
        if (((BlockItem)item).m_40576_(new BlockPlaceContext(new UseOnContext((Player)fakePlayer, InteractionHand.MAIN_HAND, result))).m_19080_()) {
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            this.mob.play("se_installation");
        }
        this.placePos = null;
    }

    @Override
    public void resetTask() {
        this.cool = 20;
        this.timeToIgnore = 0;
        this.timeToRecalcPath = 0;
    }
}

