/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.mixin;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.sistr.littlemaidrebirth.entity.iff.HasIFF;
import net.sistr.littlemaidrebirth.entity.iff.IFF;
import net.sistr.littlemaidrebirth.entity.iff.IFFImpl;
import net.sistr.littlemaidrebirth.entity.iff.IFFTag;
import net.sistr.littlemaidrebirth.entity.iff.IFFType;
import net.sistr.littlemaidrebirth.entity.iff.IFFTypeManager;
import net.sistr.littlemaidrebirth.util.PlayerAccessor;
import net.sistr.littlemaidrebirth.util.PlayerInventoryAccessor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class MixinPlayerEntity
extends LivingEntity
implements PlayerAccessor,
PlayerInventoryAccessor,
HasIFF {
    private final HasIFF iff = new IFFImpl();
    @Mutable
    @Shadow
    @Final
    private Inventory f_36093_;

    protected MixinPlayerEntity(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Shadow
    protected abstract void m_36277_(Entity var1);

    @Override
    public void onCollideWithEntity_LM(Entity entity) {
        this.m_36277_(entity);
    }

    @Override
    public Inventory getPlayerInventory_LMRB() {
        return this.f_36093_;
    }

    @Override
    public void setPlayerInventory_LMRB(Inventory inventory) {
        this.f_36093_ = inventory;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void onInit(Level world, BlockPos blockPos, float f, GameProfile gameProfile, CallbackInfo ci) {
        this.setIFFs(IFFTypeManager.getINSTANCE().getIFFTypes(world).stream().map(IFFType::createIFF).collect(Collectors.toList()));
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="RETURN")})
    public void onRead(CompoundTag nbt, CallbackInfo ci) {
        this.readIFF(nbt);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="RETURN")})
    public void onWrite(CompoundTag nbt, CallbackInfo ci) {
        this.writeIFF(nbt);
    }

    @Override
    public Optional<IFFTag> identify(LivingEntity target) {
        return this.iff.identify(target);
    }

    @Override
    public void setIFFs(List<IFF> iffs) {
        this.iff.setIFFs(iffs);
    }

    @Override
    public List<IFF> getIFFs() {
        return this.iff.getIFFs();
    }

    @Override
    public void writeIFF(CompoundTag nbt) {
        this.iff.writeIFF(nbt);
    }

    @Override
    public void readIFF(CompoundTag nbt) {
        this.iff.readIFF(nbt);
    }
}

