/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidrebirth.client.IFFScreen;
import net.sistr.littlemaidrebirth.entity.iff.HasIFF;
import net.sistr.littlemaidrebirth.entity.iff.IFF;
import net.sistr.littlemaidrebirth.entity.iff.IFFTypeManager;

public class OpenIFFScreenPacket {
    public static final ResourceLocation ID = new ResourceLocation("littlemaidrebirth", "open_iff_screen");

    public static void sendS2CPacket(Entity entity, List<IFF> iffs, Player player) {
        FriendlyByteBuf buf = OpenIFFScreenPacket.createS2CPacket(entity, iffs, player);
        NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)player), (ResourceLocation)ID, (FriendlyByteBuf)buf);
    }

    public static FriendlyByteBuf createS2CPacket(Entity entity, List<IFF> iffs, Player player) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130130_(entity.m_142049_());
        CompoundTag nbt = new CompoundTag();
        ListTag list = new ListTag();
        nbt.m_128365_("IFFs", (Tag)list);
        iffs.forEach(iff -> list.add((Object)iff.writeTag()));
        buf.m_130079_(nbt);
        return buf;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendC2SPacket(Entity entity) {
        if (!(entity instanceof HasIFF)) {
            return;
        }
        FriendlyByteBuf buf = OpenIFFScreenPacket.createC2SPacket(entity);
        NetworkManager.sendToServer((ResourceLocation)ID, (FriendlyByteBuf)buf);
    }

    public static FriendlyByteBuf createC2SPacket(Entity entity) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130130_(entity.m_142049_());
        return buf;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void receiveS2CPacket(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return;
        }
        int id = buf.m_130242_();
        CompoundTag nbt = buf.m_130260_();
        context.queue(() -> OpenIFFScreenPacket.openIFFScreen(id, nbt, player));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openIFFScreen(int id, CompoundTag nbt, Player player) {
        Entity entity = player.f_19853_.m_6815_(id);
        if (!(entity instanceof HasIFF)) {
            return;
        }
        ListTag list = nbt.m_128437_("IFFs", 10);
        List<IFF> iffs = list.stream().map(t -> (CompoundTag)t).map(t -> IFFTypeManager.getINSTANCE().loadIFF((CompoundTag)t)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        Minecraft.m_91087_().m_91152_((Screen)new IFFScreen(entity, iffs));
    }

    public static void receiveC2SPacket(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int id = buf.m_130242_();
        context.queue(() -> OpenIFFScreenPacket.openIFFScreen(id, context.getPlayer()));
    }

    private static void openIFFScreen(int id, Player player) {
        Entity entity = player.f_19853_.m_6815_(id);
        if (!(entity instanceof HasIFF) || entity instanceof TamableAnimal && !player.m_142081_().equals(((TamableAnimal)entity).m_142504_())) {
            return;
        }
        OpenIFFScreenPacket.sendS2CPacket(entity, ((HasIFF)entity).getIFFs(), player);
    }
}

