/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidrebirth.entity.iff.HasIFF;
import net.sistr.littlemaidrebirth.entity.iff.IFF;
import net.sistr.littlemaidrebirth.entity.iff.IFFTypeManager;

public class SyncIFFPacket {
    public static final ResourceLocation ID = new ResourceLocation("littlemaidrebirth", "sync_iff");

    @OnlyIn(value=Dist.CLIENT)
    public static void sendC2SPacket(Entity entity, List<IFF> iffs) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130130_(entity.m_142049_());
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        tag.m_128365_("IFFs", (Tag)list);
        iffs.forEach(iff -> list.add((Object)iff.writeTag()));
        buf.m_130079_(tag);
        NetworkManager.sendToServer((ResourceLocation)ID, (FriendlyByteBuf)buf);
    }

    public static void receiveC2SPacket(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int id = buf.m_130242_();
        CompoundTag tag = buf.m_130260_();
        context.queue(() -> SyncIFFPacket.applyIFFServer(context.getPlayer(), id, tag));
    }

    private static void applyIFFServer(Player player, int id, CompoundTag tag) {
        Entity entity = player.f_19853_.m_6815_(id);
        if (!(entity instanceof HasIFF)) {
            return;
        }
        if (entity instanceof TamableAnimal && !player.m_142081_().equals(((TamableAnimal)entity).m_142504_())) {
            return;
        }
        ListTag list = tag.m_128437_("IFFs", 10);
        List<IFF> iffs = list.stream().map(t -> (CompoundTag)t).map(t -> IFFTypeManager.getINSTANCE().loadIFF((CompoundTag)t)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        ((HasIFF)entity).setIFFs(iffs);
    }
}

