/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidrebirth.entity.Tameable;

public class SyncMovingStatePacket {
    public static final ResourceLocation ID = new ResourceLocation("littlemaidrebirth", "sync_moving_state");

    @OnlyIn(value=Dist.CLIENT)
    public static void sendC2SPacket(Entity entity, Tameable.MovingState state) {
        FriendlyByteBuf buf = SyncMovingStatePacket.createC2SPacket(entity, state);
        NetworkManager.sendToServer((ResourceLocation)ID, (FriendlyByteBuf)buf);
    }

    public static FriendlyByteBuf createC2SPacket(Entity entity, Tameable.MovingState state) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130130_(entity.m_142049_());
        buf.m_130068_((Enum)state);
        return buf;
    }

    public static void receiveC2SPacket(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int id = buf.m_130242_();
        Tameable.MovingState state = (Tameable.MovingState)buf.m_130066_(Tameable.MovingState.class);
        context.queue(() -> SyncMovingStatePacket.applyMovingStateServer(context.getPlayer(), id, state));
    }

    private static void applyMovingStateServer(Player player, int id, Tameable.MovingState state) {
        Entity entity = player.f_19853_.m_6815_(id);
        if (!(entity instanceof Tameable) || ((Tameable)entity).getTameOwnerUuid().filter(ownerId -> ownerId.equals(player.m_142081_())).isEmpty()) {
            return;
        }
        ((Tameable)entity).setMovingState(state);
        if (state == Tameable.MovingState.FREEDOM) {
            ((Tameable)entity).setFreedomPos(entity.m_142538_());
        }
    }
}

