/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.entity.compound.SoundPlayable;
import net.sistr.littlemaidmodelloader.resource.manager.LMConfigManager;
import net.sistr.littlemaidmodelloader.util.PlayerList;
import net.sistr.littlemaidrebirth.entity.Tameable;

public class SyncSoundConfigPacket {
    public static final ResourceLocation ID = new ResourceLocation("littlemaidrebirth", "sync_sound_config");

    @OnlyIn(value=Dist.CLIENT)
    public static void sendC2SPacket(Entity entity, String configName) {
        FriendlyByteBuf buf = SyncSoundConfigPacket.createC2SPacket(entity, configName);
        NetworkManager.sendToServer((ResourceLocation)ID, (FriendlyByteBuf)buf);
    }

    public static FriendlyByteBuf createC2SPacket(Entity entity, String configName) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130130_(entity.m_142049_());
        buf.m_130070_(configName);
        return buf;
    }

    public static void sendS2CPacket(Entity entity, String configName) {
        FriendlyByteBuf buf = SyncSoundConfigPacket.createS2CPacket(entity, configName);
        PlayerList.tracking((Entity)entity).forEach(player -> NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)ID, (FriendlyByteBuf)buf));
    }

    public static FriendlyByteBuf createS2CPacket(Entity entity, String configName) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130130_(entity.m_142049_());
        buf.m_130070_(configName);
        return buf;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void receiveS2CPacket(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int id = buf.m_130242_();
        String configName = buf.m_130277_();
        context.queue(() -> SyncSoundConfigPacket.applySoundConfigClient(id, configName));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void applySoundConfigClient(int id, String configName) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Level world = player.f_19853_;
        Entity entity = world.m_6815_(id);
        if (entity instanceof SoundPlayable) {
            LMConfigManager.INSTANCE.getConfig(configName).ifPresent(arg_0 -> ((SoundPlayable)((SoundPlayable)entity)).setConfigHolder(arg_0));
        }
    }

    public static void receiveC2SPacket(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int id = buf.m_130242_();
        String configName = buf.m_130136_(Short.MAX_VALUE);
        context.queue(() -> SyncSoundConfigPacket.applySoundConfigServer(context.getPlayer(), id, configName));
    }

    private static void applySoundConfigServer(Player player, int id, String configName) {
        Level world = player.f_19853_;
        Entity entity = world.m_6815_(id);
        if (!(entity instanceof SoundPlayable)) {
            return;
        }
        if (entity instanceof Tameable && ((Tameable)entity).getTameOwnerUuid().filter(ownerId -> ownerId.equals(player.m_142081_())).isEmpty()) {
            return;
        }
        LMConfigManager.INSTANCE.getConfig(configName).ifPresent(arg_0 -> ((SoundPlayable)((SoundPlayable)entity)).setConfigHolder(arg_0));
        SyncSoundConfigPacket.sendS2CPacket(entity, configName);
    }
}

