/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.setup;

import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.level.biome.BiomeModifications;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.sistr.littlemaidrebirth.api.mode.Modes;
import net.sistr.littlemaidrebirth.config.LMRBConfig;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.iff.IFFTag;
import net.sistr.littlemaidrebirth.entity.iff.IFFType;
import net.sistr.littlemaidrebirth.entity.iff.IFFTypeManager;
import net.sistr.littlemaidrebirth.mixin.SpawnRestrictionAccessor;
import net.sistr.littlemaidrebirth.network.Networking;
import net.sistr.littlemaidrebirth.setup.Registration;

public class ModSetup {
    public static final CreativeModeTab ITEM_GROUP = CreativeTabRegistry.create((ResourceLocation)new ResourceLocation("littlemaidrebirth", "common"), () -> ((Item)Items.f_42502_).m_7968_());

    public static void init() {
        Networking.INSTANCE.init();
        if (LMRBConfig.canSpawnLM()) {
            ModSetup.registerSpawnSettingLM();
        }
        IFFTypeManager iffTypeManager = IFFTypeManager.getINSTANCE();
        Registry.f_122826_.m_123024_().filter(EntityType::m_20654_).forEach(entityType -> iffTypeManager.register(EntityType.m_20613_((EntityType)entityType), new IFFType(IFFTag.UNKNOWN, (EntityType<?>)entityType)));
        iffTypeManager.register(EntityType.m_20613_((EntityType)EntityType.f_20532_), new IFFType(IFFTag.UNKNOWN, EntityType.f_20532_));
        Modes.init();
    }

    private static void registerSpawnSettingLM() {
        BiomeModifications.addProperties(context -> ModSetup.canSpawnBiome(context.getProperties().getCategory()), (context, mutable) -> mutable.getSpawnProperties().addSpawn(((EntityType)Registration.LITTLE_MAID_MOB.get()).m_20674_(), new MobSpawnSettings.SpawnerData((EntityType)Registration.LITTLE_MAID_MOB.get(), LMRBConfig.getSpawnWeightLM(), LMRBConfig.getMinSpawnGroupSizeLM(), LMRBConfig.getMaxSpawnGroupSizeLM())));
        SpawnRestrictionAccessor.callRegister((EntityType)Registration.LITTLE_MAID_MOB.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (type, world, spawnReason, pos, random) -> LittleMaidEntity.isValidNaturalSpawn((LevelAccessor)world, pos));
    }

    private static boolean canSpawnBiome(Biome.BiomeCategory category) {
        return category != Biome.BiomeCategory.NONE && category != Biome.BiomeCategory.OCEAN && category != Biome.BiomeCategory.RIVER && category != Biome.BiomeCategory.THEEND && category != Biome.BiomeCategory.NETHER;
    }
}

