/*
 * Decompiled with CFR 0.152.
 */
package mekanism.defense.common;

import mekanism.common.Mekanism;
import mekanism.common.base.IModModule;
import mekanism.common.config.MekanismModConfig;
import mekanism.common.lib.Version;
import mekanism.defense.common.config.MekanismDefenseConfig;
import mekanism.defense.common.network.DefensePacketHandler;
import mekanism.defense.common.registries.DefenseBlocks;
import mekanism.defense.common.registries.DefenseContainerTypes;
import mekanism.defense.common.registries.DefenseItems;
import mekanism.defense.common.registries.DefenseTileEntityTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="mekanismdefense")
public class MekanismDefense
implements IModModule {
    public static final String MODID = "mekanismdefense";
    public static MekanismDefense instance;
    public final Version versionNumber;
    private final DefensePacketHandler packetHandler;

    public MekanismDefense() {
        instance = this;
        Mekanism.modulesLoaded.add(instance);
        MekanismDefenseConfig.registerConfigs(ModLoadingContext.get());
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onConfigLoad);
        DefenseItems.ITEMS.register(modEventBus);
        DefenseBlocks.BLOCKS.register(modEventBus);
        DefenseContainerTypes.CONTAINER_TYPES.register(modEventBus);
        DefenseTileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
        this.versionNumber = new Version(ModLoadingContext.get().getActiveContainer());
        this.packetHandler = new DefensePacketHandler();
    }

    public static DefensePacketHandler packetHandler() {
        return MekanismDefense.instance.packetHandler;
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.packetHandler.initialize();
        Mekanism.logger.info("Loaded 'Mekanism Defense' module.");
    }

    private void serverStopped(ServerStoppedEvent event) {
    }

    public Version getVersion() {
        return this.versionNumber;
    }

    public String getName() {
        return "Defense";
    }

    public void resetClient() {
    }

    private void onConfigLoad(ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof MekanismModConfig) {
            MekanismModConfig mekConfig = (MekanismModConfig)config;
            mekConfig.clearCache();
        }
    }
}

